<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Plinovod StructType
 * @subpackage Structs
 */
class Plinovod extends AbstractStructBase
{
    /**
     * The Aktiven
     * @var bool
     */
    public $Aktiven;
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The Sifra
     * @var string
     */
    public $Sifra;
    /**
     * The Oznaka
     * @var string
     */
    public $Oznaka;
    /**
     * The Naziv
     * @var string
     */
    public $Naziv;
    /**
     * The NazivniTlak
     * @var float
     */
    public $NazivniTlak;
    /**
     * The PosevnaDolzina
     * @var float
     */
    public $PosevnaDolzina;
    /**
     * The LetoIzgradnje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LetoIzgradnje;
    /**
     * The NadrejeniMagistralniVod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NadrejeniMagistralniVod;
    /**
     * The NadrejeniRegionalniVod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NadrejeniRegionalniVod;
    /**
     * The NadrejeniPrikljucniVod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NadrejeniPrikljucniVod;
    /**
     * The MestnaMreza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MestnaMreza;
    /**
     * Constructor method for Plinovod
     * @uses Plinovod::setAktiven()
     * @uses Plinovod::setId()
     * @uses Plinovod::setSifra()
     * @uses Plinovod::setOznaka()
     * @uses Plinovod::setNaziv()
     * @uses Plinovod::setNazivniTlak()
     * @uses Plinovod::setPosevnaDolzina()
     * @uses Plinovod::setLetoIzgradnje()
     * @uses Plinovod::setNadrejeniMagistralniVod()
     * @uses Plinovod::setNadrejeniRegionalniVod()
     * @uses Plinovod::setNadrejeniPrikljucniVod()
     * @uses Plinovod::setMestnaMreza()
     * @param bool $aktiven
     * @param int $id
     * @param string $sifra
     * @param string $oznaka
     * @param string $naziv
     * @param float $nazivniTlak
     * @param float $posevnaDolzina
     * @param int $letoIzgradnje
     * @param int $nadrejeniMagistralniVod
     * @param int $nadrejeniRegionalniVod
     * @param int $nadrejeniPrikljucniVod
     * @param string $mestnaMreza
     */
    public function __construct($aktiven = null, $id = null, $sifra = null, $oznaka = null, $naziv = null, $nazivniTlak = null, $posevnaDolzina = null, $letoIzgradnje = null, $nadrejeniMagistralniVod = null, $nadrejeniRegionalniVod = null, $nadrejeniPrikljucniVod = null, $mestnaMreza = null)
    {
        $this
            ->setAktiven($aktiven)
            ->setId($id)
            ->setSifra($sifra)
            ->setOznaka($oznaka)
            ->setNaziv($naziv)
            ->setNazivniTlak($nazivniTlak)
            ->setPosevnaDolzina($posevnaDolzina)
            ->setLetoIzgradnje($letoIzgradnje)
            ->setNadrejeniMagistralniVod($nadrejeniMagistralniVod)
            ->setNadrejeniRegionalniVod($nadrejeniRegionalniVod)
            ->setNadrejeniPrikljucniVod($nadrejeniPrikljucniVod)
            ->setMestnaMreza($mestnaMreza);
    }
    /**
     * Get Aktiven value
     * @return bool|null
     */
    public function getAktiven()
    {
        return $this->Aktiven;
    }
    /**
     * Set Aktiven value
     * @param bool $aktiven
     * @return \StructType\Plinovod
     */
    public function setAktiven($aktiven = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktiven) && !is_bool($aktiven)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktiven, true), gettype($aktiven)), __LINE__);
        }
        $this->Aktiven = $aktiven;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Plinovod
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->Sifra;
    }
    /**
     * Set Sifra value
     * @param string $sifra
     * @return \StructType\Plinovod
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        $this->Sifra = $sifra;
        return $this;
    }
    /**
     * Get Oznaka value
     * @return string|null
     */
    public function getOznaka()
    {
        return $this->Oznaka;
    }
    /**
     * Set Oznaka value
     * @param string $oznaka
     * @return \StructType\Plinovod
     */
    public function setOznaka($oznaka = null)
    {
        // validation for constraint: string
        if (!is_null($oznaka) && !is_string($oznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oznaka, true), gettype($oznaka)), __LINE__);
        }
        $this->Oznaka = $oznaka;
        return $this;
    }
    /**
     * Get Naziv value
     * @return string|null
     */
    public function getNaziv()
    {
        return $this->Naziv;
    }
    /**
     * Set Naziv value
     * @param string $naziv
     * @return \StructType\Plinovod
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        $this->Naziv = $naziv;
        return $this;
    }
    /**
     * Get NazivniTlak value
     * @return float|null
     */
    public function getNazivniTlak()
    {
        return $this->NazivniTlak;
    }
    /**
     * Set NazivniTlak value
     * @param float $nazivniTlak
     * @return \StructType\Plinovod
     */
    public function setNazivniTlak($nazivniTlak = null)
    {
        // validation for constraint: float
        if (!is_null($nazivniTlak) && !(is_float($nazivniTlak) || is_numeric($nazivniTlak))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nazivniTlak, true), gettype($nazivniTlak)), __LINE__);
        }
        $this->NazivniTlak = $nazivniTlak;
        return $this;
    }
    /**
     * Get PosevnaDolzina value
     * @return float|null
     */
    public function getPosevnaDolzina()
    {
        return $this->PosevnaDolzina;
    }
    /**
     * Set PosevnaDolzina value
     * @param float $posevnaDolzina
     * @return \StructType\Plinovod
     */
    public function setPosevnaDolzina($posevnaDolzina = null)
    {
        // validation for constraint: float
        if (!is_null($posevnaDolzina) && !(is_float($posevnaDolzina) || is_numeric($posevnaDolzina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($posevnaDolzina, true), gettype($posevnaDolzina)), __LINE__);
        }
        $this->PosevnaDolzina = $posevnaDolzina;
        return $this;
    }
    /**
     * Get LetoIzgradnje value
     * @return int|null
     */
    public function getLetoIzgradnje()
    {
        return $this->LetoIzgradnje;
    }
    /**
     * Set LetoIzgradnje value
     * @param int $letoIzgradnje
     * @return \StructType\Plinovod
     */
    public function setLetoIzgradnje($letoIzgradnje = null)
    {
        // validation for constraint: int
        if (!is_null($letoIzgradnje) && !(is_int($letoIzgradnje) || ctype_digit($letoIzgradnje))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letoIzgradnje, true), gettype($letoIzgradnje)), __LINE__);
        }
        $this->LetoIzgradnje = $letoIzgradnje;
        return $this;
    }
    /**
     * Get NadrejeniMagistralniVod value
     * @return int|null
     */
    public function getNadrejeniMagistralniVod()
    {
        return $this->NadrejeniMagistralniVod;
    }
    /**
     * Set NadrejeniMagistralniVod value
     * @param int $nadrejeniMagistralniVod
     * @return \StructType\Plinovod
     */
    public function setNadrejeniMagistralniVod($nadrejeniMagistralniVod = null)
    {
        // validation for constraint: int
        if (!is_null($nadrejeniMagistralniVod) && !(is_int($nadrejeniMagistralniVod) || ctype_digit($nadrejeniMagistralniVod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nadrejeniMagistralniVod, true), gettype($nadrejeniMagistralniVod)), __LINE__);
        }
        $this->NadrejeniMagistralniVod = $nadrejeniMagistralniVod;
        return $this;
    }
    /**
     * Get NadrejeniRegionalniVod value
     * @return int|null
     */
    public function getNadrejeniRegionalniVod()
    {
        return $this->NadrejeniRegionalniVod;
    }
    /**
     * Set NadrejeniRegionalniVod value
     * @param int $nadrejeniRegionalniVod
     * @return \StructType\Plinovod
     */
    public function setNadrejeniRegionalniVod($nadrejeniRegionalniVod = null)
    {
        // validation for constraint: int
        if (!is_null($nadrejeniRegionalniVod) && !(is_int($nadrejeniRegionalniVod) || ctype_digit($nadrejeniRegionalniVod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nadrejeniRegionalniVod, true), gettype($nadrejeniRegionalniVod)), __LINE__);
        }
        $this->NadrejeniRegionalniVod = $nadrejeniRegionalniVod;
        return $this;
    }
    /**
     * Get NadrejeniPrikljucniVod value
     * @return int|null
     */
    public function getNadrejeniPrikljucniVod()
    {
        return $this->NadrejeniPrikljucniVod;
    }
    /**
     * Set NadrejeniPrikljucniVod value
     * @param int $nadrejeniPrikljucniVod
     * @return \StructType\Plinovod
     */
    public function setNadrejeniPrikljucniVod($nadrejeniPrikljucniVod = null)
    {
        // validation for constraint: int
        if (!is_null($nadrejeniPrikljucniVod) && !(is_int($nadrejeniPrikljucniVod) || ctype_digit($nadrejeniPrikljucniVod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nadrejeniPrikljucniVod, true), gettype($nadrejeniPrikljucniVod)), __LINE__);
        }
        $this->NadrejeniPrikljucniVod = $nadrejeniPrikljucniVod;
        return $this;
    }
    /**
     * Get MestnaMreza value
     * @return string|null
     */
    public function getMestnaMreza()
    {
        return $this->MestnaMreza;
    }
    /**
     * Set MestnaMreza value
     * @param string $mestnaMreza
     * @return \StructType\Plinovod
     */
    public function setMestnaMreza($mestnaMreza = null)
    {
        // validation for constraint: string
        if (!is_null($mestnaMreza) && !is_string($mestnaMreza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mestnaMreza, true), gettype($mestnaMreza)), __LINE__);
        }
        $this->MestnaMreza = $mestnaMreza;
        return $this;
    }
}
