<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Objekt StructType
 * @subpackage Structs
 */
class Objekt extends AbstractStructBase
{
    /**
     * The Aktiven
     * @var bool
     */
    public $Aktiven;
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The Sifra
     * @var string
     */
    public $Sifra;
    /**
     * The Naziv
     * @var string
     */
    public $Naziv;
    /**
     * The Tip
     * @var string
     */
    public $Tip;
    /**
     * The LetoIzgradnje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LetoIzgradnje;
    /**
     * The VstopniPlinovod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VstopniPlinovod;
    /**
     * The ZemljepisnaDolzina
     * @var float
     */
    public $ZemljepisnaDolzina;
    /**
     * The ZemljepisnaSirina
     * @var float
     */
    public $ZemljepisnaSirina;
    /**
     * Constructor method for Objekt
     * @uses Objekt::setAktiven()
     * @uses Objekt::setId()
     * @uses Objekt::setSifra()
     * @uses Objekt::setNaziv()
     * @uses Objekt::setTip()
     * @uses Objekt::setLetoIzgradnje()
     * @uses Objekt::setVstopniPlinovod()
     * @uses Objekt::setZemljepisnaDolzina()
     * @uses Objekt::setZemljepisnaSirina()
     * @param bool $aktiven
     * @param int $id
     * @param string $sifra
     * @param string $naziv
     * @param string $tip
     * @param int $letoIzgradnje
     * @param int $vstopniPlinovod
     * @param float $zemljepisnaDolzina
     * @param float $zemljepisnaSirina
     */
    public function __construct($aktiven = null, $id = null, $sifra = null, $naziv = null, $tip = null, $letoIzgradnje = null, $vstopniPlinovod = null, $zemljepisnaDolzina = null, $zemljepisnaSirina = null)
    {
        $this
            ->setAktiven($aktiven)
            ->setId($id)
            ->setSifra($sifra)
            ->setNaziv($naziv)
            ->setTip($tip)
            ->setLetoIzgradnje($letoIzgradnje)
            ->setVstopniPlinovod($vstopniPlinovod)
            ->setZemljepisnaDolzina($zemljepisnaDolzina)
            ->setZemljepisnaSirina($zemljepisnaSirina);
    }
    /**
     * Get Aktiven value
     * @return bool|null
     */
    public function getAktiven()
    {
        return $this->Aktiven;
    }
    /**
     * Set Aktiven value
     * @param bool $aktiven
     * @return \StructType\Objekt
     */
    public function setAktiven($aktiven = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktiven) && !is_bool($aktiven)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktiven, true), gettype($aktiven)), __LINE__);
        }
        $this->Aktiven = $aktiven;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Objekt
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->Sifra;
    }
    /**
     * Set Sifra value
     * @param string $sifra
     * @return \StructType\Objekt
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        $this->Sifra = $sifra;
        return $this;
    }
    /**
     * Get Naziv value
     * @return string|null
     */
    public function getNaziv()
    {
        return $this->Naziv;
    }
    /**
     * Set Naziv value
     * @param string $naziv
     * @return \StructType\Objekt
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        $this->Naziv = $naziv;
        return $this;
    }
    /**
     * Get Tip value
     * @return string|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param string $tip
     * @return \StructType\Objekt
     */
    public function setTip($tip = null)
    {
        // validation for constraint: string
        if (!is_null($tip) && !is_string($tip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Get LetoIzgradnje value
     * @return int|null
     */
    public function getLetoIzgradnje()
    {
        return $this->LetoIzgradnje;
    }
    /**
     * Set LetoIzgradnje value
     * @param int $letoIzgradnje
     * @return \StructType\Objekt
     */
    public function setLetoIzgradnje($letoIzgradnje = null)
    {
        // validation for constraint: int
        if (!is_null($letoIzgradnje) && !(is_int($letoIzgradnje) || ctype_digit($letoIzgradnje))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letoIzgradnje, true), gettype($letoIzgradnje)), __LINE__);
        }
        $this->LetoIzgradnje = $letoIzgradnje;
        return $this;
    }
    /**
     * Get VstopniPlinovod value
     * @return int|null
     */
    public function getVstopniPlinovod()
    {
        return $this->VstopniPlinovod;
    }
    /**
     * Set VstopniPlinovod value
     * @param int $vstopniPlinovod
     * @return \StructType\Objekt
     */
    public function setVstopniPlinovod($vstopniPlinovod = null)
    {
        // validation for constraint: int
        if (!is_null($vstopniPlinovod) && !(is_int($vstopniPlinovod) || ctype_digit($vstopniPlinovod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vstopniPlinovod, true), gettype($vstopniPlinovod)), __LINE__);
        }
        $this->VstopniPlinovod = $vstopniPlinovod;
        return $this;
    }
    /**
     * Get ZemljepisnaDolzina value
     * @return float|null
     */
    public function getZemljepisnaDolzina()
    {
        return $this->ZemljepisnaDolzina;
    }
    /**
     * Set ZemljepisnaDolzina value
     * @param float $zemljepisnaDolzina
     * @return \StructType\Objekt
     */
    public function setZemljepisnaDolzina($zemljepisnaDolzina = null)
    {
        // validation for constraint: float
        if (!is_null($zemljepisnaDolzina) && !(is_float($zemljepisnaDolzina) || is_numeric($zemljepisnaDolzina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zemljepisnaDolzina, true), gettype($zemljepisnaDolzina)), __LINE__);
        }
        $this->ZemljepisnaDolzina = $zemljepisnaDolzina;
        return $this;
    }
    /**
     * Get ZemljepisnaSirina value
     * @return float|null
     */
    public function getZemljepisnaSirina()
    {
        return $this->ZemljepisnaSirina;
    }
    /**
     * Set ZemljepisnaSirina value
     * @param float $zemljepisnaSirina
     * @return \StructType\Objekt
     */
    public function setZemljepisnaSirina($zemljepisnaSirina = null)
    {
        // validation for constraint: float
        if (!is_null($zemljepisnaSirina) && !(is_float($zemljepisnaSirina) || is_numeric($zemljepisnaSirina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zemljepisnaSirina, true), gettype($zemljepisnaSirina)), __LINE__);
        }
        $this->ZemljepisnaSirina = $zemljepisnaSirina;
        return $this;
    }
}
