<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Layer StructType
 * @subpackage Structs
 */
class Layer extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The count
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $count;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $total;
    /**
     * The Index
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Index[]
     */
    public $Index;
    /**
     * The Dataset
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Dataset[]
     */
    public $Dataset;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Filter
     */
    public $Filter;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Sort
     */
    public $Sort;
    /**
     * The Field
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Field[]
     */
    public $Field;
    /**
     * The start
     * Meta information extracted from the WSDL
     * - default: 1
     * @var int
     */
    public $start;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - default: 10
     * @var int
     */
    public $limit;
    /**
     * The geometry
     * @var string
     */
    public $geometry;
    /**
     * The srsName
     * @var string
     */
    public $srsName;
    /**
     * The Record
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Record[]
     */
    public $Record;
    /**
     * The from
     * @var int
     */
    public $from;
    /**
     * The to
     * @var int
     */
    public $to;
    /**
     * Constructor method for Layer
     * @uses Layer::setId()
     * @uses Layer::setName()
     * @uses Layer::setCount()
     * @uses Layer::setTotal()
     * @uses Layer::setIndex()
     * @uses Layer::setDataset()
     * @uses Layer::setFilter()
     * @uses Layer::setSort()
     * @uses Layer::setField()
     * @uses Layer::setStart()
     * @uses Layer::setLimit()
     * @uses Layer::setGeometry()
     * @uses Layer::setSrsName()
     * @uses Layer::setRecord()
     * @uses Layer::setFrom()
     * @uses Layer::setTo()
     * @param string $id
     * @param string $name
     * @param int $count
     * @param int $total
     * @param \StructType\Index[] $index
     * @param \StructType\Dataset[] $dataset
     * @param \StructType\Filter $filter
     * @param \StructType\Sort $sort
     * @param \StructType\Field[] $field
     * @param int $start
     * @param int $limit
     * @param string $geometry
     * @param string $srsName
     * @param \StructType\Record[] $record
     * @param int $from
     * @param int $to
     */
    public function __construct($id = null, $name = null, $count = null, $total = null, array $index = array(), array $dataset = array(), \StructType\Filter $filter = null, \StructType\Sort $sort = null, array $field = array(), $start = 1, $limit = 10, $geometry = null, $srsName = null, array $record = array(), $from = null, $to = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setCount($count)
            ->setTotal($total)
            ->setIndex($index)
            ->setDataset($dataset)
            ->setFilter($filter)
            ->setSort($sort)
            ->setField($field)
            ->setStart($start)
            ->setLimit($limit)
            ->setGeometry($geometry)
            ->setSrsName($srsName)
            ->setRecord($record)
            ->setFrom($from)
            ->setTo($to);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Layer
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Layer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get count value
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\Layer
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get total value
     * @return int
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\Layer
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get Index value
     * @return \StructType\Index[]|null
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * This method is responsible for validating the values passed to the setIndex method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIndex method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIndexForArrayConstraintsFromSetIndex(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $layerIndexItem) {
            // validation for constraint: itemType
            if (!$layerIndexItem instanceof \StructType\Index) {
                $invalidValues[] = is_object($layerIndexItem) ? get_class($layerIndexItem) : sprintf('%s(%s)', gettype($layerIndexItem), var_export($layerIndexItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Index property can only contain items of type \StructType\Index, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Index value
     * @throws \InvalidArgumentException
     * @param \StructType\Index[] $index
     * @return \StructType\Layer
     */
    public function setIndex(array $index = array())
    {
        // validation for constraint: array
        if ('' !== ($indexArrayErrorMessage = self::validateIndexForArrayConstraintsFromSetIndex($index))) {
            throw new \InvalidArgumentException($indexArrayErrorMessage, __LINE__);
        }
        $this->Index = $index;
        return $this;
    }
    /**
     * Add item to Index value
     * @throws \InvalidArgumentException
     * @param \StructType\Index $item
     * @return \StructType\Layer
     */
    public function addToIndex(\StructType\Index $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Index) {
            throw new \InvalidArgumentException(sprintf('The Index property can only contain items of type \StructType\Index, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Index[] = $item;
        return $this;
    }
    /**
     * Get Dataset value
     * @return \StructType\Dataset[]|null
     */
    public function getDataset()
    {
        return $this->Dataset;
    }
    /**
     * This method is responsible for validating the values passed to the setDataset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDataset method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatasetForArrayConstraintsFromSetDataset(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $layerDatasetItem) {
            // validation for constraint: itemType
            if (!$layerDatasetItem instanceof \StructType\Dataset) {
                $invalidValues[] = is_object($layerDatasetItem) ? get_class($layerDatasetItem) : sprintf('%s(%s)', gettype($layerDatasetItem), var_export($layerDatasetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dataset property can only contain items of type \StructType\Dataset, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dataset value
     * @throws \InvalidArgumentException
     * @param \StructType\Dataset[] $dataset
     * @return \StructType\Layer
     */
    public function setDataset(array $dataset = array())
    {
        // validation for constraint: array
        if ('' !== ($datasetArrayErrorMessage = self::validateDatasetForArrayConstraintsFromSetDataset($dataset))) {
            throw new \InvalidArgumentException($datasetArrayErrorMessage, __LINE__);
        }
        $this->Dataset = $dataset;
        return $this;
    }
    /**
     * Add item to Dataset value
     * @throws \InvalidArgumentException
     * @param \StructType\Dataset $item
     * @return \StructType\Layer
     */
    public function addToDataset(\StructType\Dataset $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dataset) {
            throw new \InvalidArgumentException(sprintf('The Dataset property can only contain items of type \StructType\Dataset, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dataset[] = $item;
        return $this;
    }
    /**
     * Get Filter value
     * @return \StructType\Filter|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param \StructType\Filter $filter
     * @return \StructType\Layer
     */
    public function setFilter(\StructType\Filter $filter = null)
    {
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get Sort value
     * @return \StructType\Sort|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param \StructType\Sort $sort
     * @return \StructType\Layer
     */
    public function setSort(\StructType\Sort $sort = null)
    {
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get Field value
     * @return \StructType\Field[]|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * This method is responsible for validating the values passed to the setField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldForArrayConstraintsFromSetField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $layerFieldItem) {
            // validation for constraint: itemType
            if (!$layerFieldItem instanceof \StructType\Field) {
                $invalidValues[] = is_object($layerFieldItem) ? get_class($layerFieldItem) : sprintf('%s(%s)', gettype($layerFieldItem), var_export($layerFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Field property can only contain items of type \StructType\Field, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field[] $field
     * @return \StructType\Layer
     */
    public function setField(array $field = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldArrayErrorMessage = self::validateFieldForArrayConstraintsFromSetField($field))) {
            throw new \InvalidArgumentException($fieldArrayErrorMessage, __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Add item to Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field $item
     * @return \StructType\Layer
     */
    public function addToField(\StructType\Field $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Field) {
            throw new \InvalidArgumentException(sprintf('The Field property can only contain items of type \StructType\Field, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Field[] = $item;
        return $this;
    }
    /**
     * Get start value
     * @return int|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param int $start
     * @return \StructType\Layer
     */
    public function setStart($start = 1)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\Layer
     */
    public function setLimit($limit = 10)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get geometry value
     * @return string|null
     */
    public function getGeometry()
    {
        return $this->geometry;
    }
    /**
     * Set geometry value
     * @uses \EnumType\Geo::valueIsValid()
     * @uses \EnumType\Geo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geometry
     * @return \StructType\Layer
     */
    public function setGeometry($geometry = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Geo::valueIsValid($geometry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Geo', is_array($geometry) ? implode(', ', $geometry) : var_export($geometry, true), implode(', ', \EnumType\Geo::getValidValues())), __LINE__);
        }
        $this->geometry = $geometry;
        return $this;
    }
    /**
     * Get srsName value
     * @return string|null
     */
    public function getSrsName()
    {
        return $this->srsName;
    }
    /**
     * Set srsName value
     * @uses \EnumType\Srs::valueIsValid()
     * @uses \EnumType\Srs::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $srsName
     * @return \StructType\Layer
     */
    public function setSrsName($srsName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Srs::valueIsValid($srsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Srs', is_array($srsName) ? implode(', ', $srsName) : var_export($srsName, true), implode(', ', \EnumType\Srs::getValidValues())), __LINE__);
        }
        $this->srsName = $srsName;
        return $this;
    }
    /**
     * Get Record value
     * @return \StructType\Record[]|null
     */
    public function getRecord()
    {
        return $this->Record;
    }
    /**
     * This method is responsible for validating the values passed to the setRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecordForArrayConstraintsFromSetRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $layerRecordItem) {
            // validation for constraint: itemType
            if (!$layerRecordItem instanceof \StructType\Record) {
                $invalidValues[] = is_object($layerRecordItem) ? get_class($layerRecordItem) : sprintf('%s(%s)', gettype($layerRecordItem), var_export($layerRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Record property can only contain items of type \StructType\Record, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Record value
     * @throws \InvalidArgumentException
     * @param \StructType\Record[] $record
     * @return \StructType\Layer
     */
    public function setRecord(array $record = array())
    {
        // validation for constraint: array
        if ('' !== ($recordArrayErrorMessage = self::validateRecordForArrayConstraintsFromSetRecord($record))) {
            throw new \InvalidArgumentException($recordArrayErrorMessage, __LINE__);
        }
        $this->Record = $record;
        return $this;
    }
    /**
     * Add item to Record value
     * @throws \InvalidArgumentException
     * @param \StructType\Record $item
     * @return \StructType\Layer
     */
    public function addToRecord(\StructType\Record $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Record) {
            throw new \InvalidArgumentException(sprintf('The Record property can only contain items of type \StructType\Record, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Record[] = $item;
        return $this;
    }
    /**
     * Get from value
     * @return int|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param int $from
     * @return \StructType\Layer
     */
    public function setFrom($from = null)
    {
        // validation for constraint: int
        if (!is_null($from) && !(is_int($from) || ctype_digit($from))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return int|null
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param int $to
     * @return \StructType\Layer
     */
    public function setTo($to = null)
    {
        // validation for constraint: int
        if (!is_null($to) && !(is_int($to) || ctype_digit($to))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
}
