<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLayerInfoRequest StructType
 * @subpackage Structs
 */
class GetLayerInfoRequest extends AbstractStructBase
{
    /**
     * The Security
     * @var \StructType\Security2
     */
    public $Security;
    /**
     * The Layer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Layer[]
     */
    public $Layer;
    /**
     * Constructor method for GetLayerInfoRequest
     * @uses GetLayerInfoRequest::setSecurity()
     * @uses GetLayerInfoRequest::setLayer()
     * @param \StructType\Security2 $security
     * @param \StructType\Layer[] $layer
     */
    public function __construct(\StructType\Security2 $security = null, array $layer = array())
    {
        $this
            ->setSecurity($security)
            ->setLayer($layer);
    }
    /**
     * Get Security value
     * @return \StructType\Security2|null
     */
    public function getSecurity()
    {
        return $this->Security;
    }
    /**
     * Set Security value
     * @param \StructType\Security2 $security
     * @return \StructType\GetLayerInfoRequest
     */
    public function setSecurity(\StructType\Security2 $security = null)
    {
        $this->Security = $security;
        return $this;
    }
    /**
     * Get Layer value
     * @return \StructType\Layer[]|null
     */
    public function getLayer()
    {
        return $this->Layer;
    }
    /**
     * This method is responsible for validating the values passed to the setLayer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLayer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLayerForArrayConstraintsFromSetLayer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getLayerInfoRequestLayerItem) {
            // validation for constraint: itemType
            if (!$getLayerInfoRequestLayerItem instanceof \StructType\Layer) {
                $invalidValues[] = is_object($getLayerInfoRequestLayerItem) ? get_class($getLayerInfoRequestLayerItem) : sprintf('%s(%s)', gettype($getLayerInfoRequestLayerItem), var_export($getLayerInfoRequestLayerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Layer property can only contain items of type \StructType\Layer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Layer value
     * @throws \InvalidArgumentException
     * @param \StructType\Layer[] $layer
     * @return \StructType\GetLayerInfoRequest
     */
    public function setLayer(array $layer = array())
    {
        // validation for constraint: array
        if ('' !== ($layerArrayErrorMessage = self::validateLayerForArrayConstraintsFromSetLayer($layer))) {
            throw new \InvalidArgumentException($layerArrayErrorMessage, __LINE__);
        }
        $this->Layer = $layer;
        return $this;
    }
    /**
     * Add item to Layer value
     * @throws \InvalidArgumentException
     * @param \StructType\Layer $item
     * @return \StructType\GetLayerInfoRequest
     */
    public function addToLayer(\StructType\Layer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Layer) {
            throw new \InvalidArgumentException(sprintf('The Layer property can only contain items of type \StructType\Layer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Layer[] = $item;
        return $this;
    }
}
