<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Filter StructType
 * @subpackage Structs
 */
class Filter extends AbstractStructBase
{
    /**
     * The byid
     * @var string
     */
    public $byid;
    /**
     * The byname
     * @var string
     */
    public $byname;
    /**
     * The Index
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Index
     */
    public $Index;
    /**
     * The Field
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Field[]
     */
    public $Field;
    /**
     * Constructor method for Filter
     * @uses Filter::setByid()
     * @uses Filter::setByname()
     * @uses Filter::setIndex()
     * @uses Filter::setField()
     * @param string $byid
     * @param string $byname
     * @param \StructType\Index $index
     * @param \StructType\Field[] $field
     */
    public function __construct($byid = null, $byname = null, \StructType\Index $index = null, array $field = array())
    {
        $this
            ->setByid($byid)
            ->setByname($byname)
            ->setIndex($index)
            ->setField($field);
    }
    /**
     * Get byid value
     * @return string|null
     */
    public function getByid()
    {
        return $this->byid;
    }
    /**
     * Set byid value
     * @param string $byid
     * @return \StructType\Filter
     */
    public function setByid($byid = null)
    {
        // validation for constraint: string
        if (!is_null($byid) && !is_string($byid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($byid, true), gettype($byid)), __LINE__);
        }
        $this->byid = $byid;
        return $this;
    }
    /**
     * Get byname value
     * @return string|null
     */
    public function getByname()
    {
        return $this->byname;
    }
    /**
     * Set byname value
     * @param string $byname
     * @return \StructType\Filter
     */
    public function setByname($byname = null)
    {
        // validation for constraint: string
        if (!is_null($byname) && !is_string($byname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($byname, true), gettype($byname)), __LINE__);
        }
        $this->byname = $byname;
        return $this;
    }
    /**
     * Get Index value
     * @return \StructType\Index|null
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param \StructType\Index $index
     * @return \StructType\Filter
     */
    public function setIndex(\StructType\Index $index = null)
    {
        $this->Index = $index;
        return $this;
    }
    /**
     * Get Field value
     * @return \StructType\Field[]|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * This method is responsible for validating the values passed to the setField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldForArrayConstraintsFromSetField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $filterFieldItem) {
            // validation for constraint: itemType
            if (!$filterFieldItem instanceof \StructType\Field) {
                $invalidValues[] = is_object($filterFieldItem) ? get_class($filterFieldItem) : sprintf('%s(%s)', gettype($filterFieldItem), var_export($filterFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Field property can only contain items of type \StructType\Field, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field[] $field
     * @return \StructType\Filter
     */
    public function setField(array $field = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldArrayErrorMessage = self::validateFieldForArrayConstraintsFromSetField($field))) {
            throw new \InvalidArgumentException($fieldArrayErrorMessage, __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Add item to Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field $item
     * @return \StructType\Filter
     */
    public function addToField(\StructType\Field $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Field) {
            throw new \InvalidArgumentException(sprintf('The Field property can only contain items of type \StructType\Field, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Field[] = $item;
        return $this;
    }
}
