<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dataset StructType
 * @subpackage Structs
 */
class Dataset extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The Field
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Field[]
     */
    public $Field;
    /**
     * The multiple
     * @var bool
     */
    public $multiple;
    /**
     * The virtual
     * @var bool
     */
    public $virtual;
    /**
     * Constructor method for Dataset
     * @uses Dataset::setId()
     * @uses Dataset::setName()
     * @uses Dataset::setField()
     * @uses Dataset::setMultiple()
     * @uses Dataset::setVirtual()
     * @param string $id
     * @param string $name
     * @param \StructType\Field[] $field
     * @param bool $multiple
     * @param bool $virtual
     */
    public function __construct($id = null, $name = null, array $field = array(), $multiple = null, $virtual = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setField($field)
            ->setMultiple($multiple)
            ->setVirtual($virtual);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Dataset
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Dataset
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get Field value
     * @return \StructType\Field[]|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * This method is responsible for validating the values passed to the setField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldForArrayConstraintsFromSetField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datasetFieldItem) {
            // validation for constraint: itemType
            if (!$datasetFieldItem instanceof \StructType\Field) {
                $invalidValues[] = is_object($datasetFieldItem) ? get_class($datasetFieldItem) : sprintf('%s(%s)', gettype($datasetFieldItem), var_export($datasetFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Field property can only contain items of type \StructType\Field, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field[] $field
     * @return \StructType\Dataset
     */
    public function setField(array $field = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldArrayErrorMessage = self::validateFieldForArrayConstraintsFromSetField($field))) {
            throw new \InvalidArgumentException($fieldArrayErrorMessage, __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Add item to Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field $item
     * @return \StructType\Dataset
     */
    public function addToField(\StructType\Field $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Field) {
            throw new \InvalidArgumentException(sprintf('The Field property can only contain items of type \StructType\Field, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Field[] = $item;
        return $this;
    }
    /**
     * Get multiple value
     * @return bool|null
     */
    public function getMultiple()
    {
        return $this->multiple;
    }
    /**
     * Set multiple value
     * @param bool $multiple
     * @return \StructType\Dataset
     */
    public function setMultiple($multiple = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiple) && !is_bool($multiple)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiple, true), gettype($multiple)), __LINE__);
        }
        $this->multiple = $multiple;
        return $this;
    }
    /**
     * Get virtual value
     * @return bool|null
     */
    public function getVirtual()
    {
        return $this->virtual;
    }
    /**
     * Set virtual value
     * @param bool $virtual
     * @return \StructType\Dataset
     */
    public function setVirtual($virtual = null)
    {
        // validation for constraint: boolean
        if (!is_null($virtual) && !is_bool($virtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($virtual, true), gettype($virtual)), __LINE__);
        }
        $this->virtual = $virtual;
        return $this;
    }
}
