<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://gis.plinovodi.si/wsdl11/soap11/vps',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://gis.plinovodi.si/wsdl11/soap11/vps',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetSession operation/method
 */
if ($get->GetSession(new \StructType\GetSessionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLayerList operation/method
 */
if ($get->GetLayerList(new \StructType\GetLayerListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLayerInfo operation/method
 */
if ($get->GetLayerInfo(new \StructType\GetLayerInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLayerData operation/method
 */
if ($get->GetLayerData(new \StructType\GetLayerDataRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Vps ServiceType
 */
$vps = new \ServiceType\Vps($options);
/**
 * Sample call for VpsSeznamPlinovodov operation/method
 */
if ($vps->VpsSeznamPlinovodov(new \StructType\VpsSeznamPlinovodovRequest()) !== false) {
    print_r($vps->getResult());
} else {
    print_r($vps->getLastError());
}
/**
 * Sample call for VpsSeznamObjektov operation/method
 */
if ($vps->VpsSeznamObjektov(new \StructType\VpsSeznamObjektovRequest()) !== false) {
    print_r($vps->getResult());
} else {
    print_r($vps->getLastError());
}
