<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Seznam StructType
 * @subpackage Structs
 */
class Seznam extends AbstractStructBase
{
    /**
     * The Ustvarjen
     * @var string
     */
    public $Ustvarjen;
    /**
     * The Plinovod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Plinovod[]
     */
    public $Plinovod;
    /**
     * The Objekt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Objekt[]
     */
    public $Objekt;
    /**
     * Constructor method for Seznam
     * @uses Seznam::setUstvarjen()
     * @uses Seznam::setPlinovod()
     * @uses Seznam::setObjekt()
     * @param string $ustvarjen
     * @param \StructType\Plinovod[] $plinovod
     * @param \StructType\Objekt[] $objekt
     */
    public function __construct($ustvarjen = null, array $plinovod = array(), array $objekt = array())
    {
        $this
            ->setUstvarjen($ustvarjen)
            ->setPlinovod($plinovod)
            ->setObjekt($objekt);
    }
    /**
     * Get Ustvarjen value
     * @return string|null
     */
    public function getUstvarjen()
    {
        return $this->Ustvarjen;
    }
    /**
     * Set Ustvarjen value
     * @param string $ustvarjen
     * @return \StructType\Seznam
     */
    public function setUstvarjen($ustvarjen = null)
    {
        // validation for constraint: string
        if (!is_null($ustvarjen) && !is_string($ustvarjen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ustvarjen, true), gettype($ustvarjen)), __LINE__);
        }
        $this->Ustvarjen = $ustvarjen;
        return $this;
    }
    /**
     * Get Plinovod value
     * @return \StructType\Plinovod[]|null
     */
    public function getPlinovod()
    {
        return $this->Plinovod;
    }
    /**
     * This method is responsible for validating the values passed to the setPlinovod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlinovod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlinovodForArrayConstraintsFromSetPlinovod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seznamPlinovodItem) {
            // validation for constraint: itemType
            if (!$seznamPlinovodItem instanceof \StructType\Plinovod) {
                $invalidValues[] = is_object($seznamPlinovodItem) ? get_class($seznamPlinovodItem) : sprintf('%s(%s)', gettype($seznamPlinovodItem), var_export($seznamPlinovodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Plinovod property can only contain items of type \StructType\Plinovod, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Plinovod value
     * @throws \InvalidArgumentException
     * @param \StructType\Plinovod[] $plinovod
     * @return \StructType\Seznam
     */
    public function setPlinovod(array $plinovod = array())
    {
        // validation for constraint: array
        if ('' !== ($plinovodArrayErrorMessage = self::validatePlinovodForArrayConstraintsFromSetPlinovod($plinovod))) {
            throw new \InvalidArgumentException($plinovodArrayErrorMessage, __LINE__);
        }
        $this->Plinovod = $plinovod;
        return $this;
    }
    /**
     * Add item to Plinovod value
     * @throws \InvalidArgumentException
     * @param \StructType\Plinovod $item
     * @return \StructType\Seznam
     */
    public function addToPlinovod(\StructType\Plinovod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Plinovod) {
            throw new \InvalidArgumentException(sprintf('The Plinovod property can only contain items of type \StructType\Plinovod, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Plinovod[] = $item;
        return $this;
    }
    /**
     * Get Objekt value
     * @return \StructType\Objekt[]|null
     */
    public function getObjekt()
    {
        return $this->Objekt;
    }
    /**
     * This method is responsible for validating the values passed to the setObjekt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObjekt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjektForArrayConstraintsFromSetObjekt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seznamObjektItem) {
            // validation for constraint: itemType
            if (!$seznamObjektItem instanceof \StructType\Objekt) {
                $invalidValues[] = is_object($seznamObjektItem) ? get_class($seznamObjektItem) : sprintf('%s(%s)', gettype($seznamObjektItem), var_export($seznamObjektItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Objekt property can only contain items of type \StructType\Objekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Objekt value
     * @throws \InvalidArgumentException
     * @param \StructType\Objekt[] $objekt
     * @return \StructType\Seznam
     */
    public function setObjekt(array $objekt = array())
    {
        // validation for constraint: array
        if ('' !== ($objektArrayErrorMessage = self::validateObjektForArrayConstraintsFromSetObjekt($objekt))) {
            throw new \InvalidArgumentException($objektArrayErrorMessage, __LINE__);
        }
        $this->Objekt = $objekt;
        return $this;
    }
    /**
     * Add item to Objekt value
     * @throws \InvalidArgumentException
     * @param \StructType\Objekt $item
     * @return \StructType\Seznam
     */
    public function addToObjekt(\StructType\Objekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Objekt) {
            throw new \InvalidArgumentException(sprintf('The Objekt property can only contain items of type \StructType\Objekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Objekt[] = $item;
        return $this;
    }
}
