<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for security2 StructType
 * @subpackage Structs
 */
class Security2 extends AbstractStructBase
{
    /**
     * The SessionInfo
     * Meta information extracted from the WSDL
     * - choice: SessionInfo | LoginInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Sessioninfo
     */
    public $SessionInfo;
    /**
     * The LoginInfo
     * Meta information extracted from the WSDL
     * - choice: SessionInfo | LoginInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Logininfo
     */
    public $LoginInfo;
    /**
     * Constructor method for security2
     * @uses Security2::setSessionInfo()
     * @uses Security2::setLoginInfo()
     * @param \StructType\Sessioninfo $sessionInfo
     * @param \StructType\Logininfo $loginInfo
     */
    public function __construct(\StructType\Sessioninfo $sessionInfo = null, \StructType\Logininfo $loginInfo = null)
    {
        $this
            ->setSessionInfo($sessionInfo)
            ->setLoginInfo($loginInfo);
    }
    /**
     * Get SessionInfo value
     * @return \StructType\Sessioninfo|null
     */
    public function getSessionInfo()
    {
        return isset($this->SessionInfo) ? $this->SessionInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSessionInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSessionInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSessionInfoForChoiceConstraintsFromSetSessionInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'LoginInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SessionInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: SessionInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SessionInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sessioninfo $sessionInfo
     * @return \StructType\Security2
     */
    public function setSessionInfo(\StructType\Sessioninfo $sessionInfo = null)
    {
        // validation for constraint: choice(SessionInfo, LoginInfo)
        if ('' !== ($sessionInfoChoiceErrorMessage = self::validateSessionInfoForChoiceConstraintsFromSetSessionInfo($sessionInfo))) {
            throw new \InvalidArgumentException($sessionInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($sessionInfo) || (is_array($sessionInfo) && empty($sessionInfo))) {
            unset($this->SessionInfo);
        } else {
            $this->SessionInfo = $sessionInfo;
        }
        return $this;
    }
    /**
     * Get LoginInfo value
     * @return \StructType\Logininfo|null
     */
    public function getLoginInfo()
    {
        return isset($this->LoginInfo) ? $this->LoginInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLoginInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoginInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoginInfoForChoiceConstraintsFromSetLoginInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SessionInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LoginInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: LoginInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LoginInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Logininfo $loginInfo
     * @return \StructType\Security2
     */
    public function setLoginInfo(\StructType\Logininfo $loginInfo = null)
    {
        // validation for constraint: choice(SessionInfo, LoginInfo)
        if ('' !== ($loginInfoChoiceErrorMessage = self::validateLoginInfoForChoiceConstraintsFromSetLoginInfo($loginInfo))) {
            throw new \InvalidArgumentException($loginInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($loginInfo) || (is_array($loginInfo) && empty($loginInfo))) {
            unset($this->LoginInfo);
        } else {
            $this->LoginInfo = $loginInfo;
        }
        return $this;
    }
}
