<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Record StructType
 * @subpackage Structs
 */
class Record extends AbstractStructBase
{
    /**
     * The Geometry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Geometry
     */
    public $Geometry;
    /**
     * The Dataset
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Dataset[]
     */
    public $Dataset;
    /**
     * Constructor method for Record
     * @uses Record::setGeometry()
     * @uses Record::setDataset()
     * @param \StructType\Geometry $geometry
     * @param \StructType\Dataset[] $dataset
     */
    public function __construct(\StructType\Geometry $geometry = null, array $dataset = array())
    {
        $this
            ->setGeometry($geometry)
            ->setDataset($dataset);
    }
    /**
     * Get Geometry value
     * @return \StructType\Geometry|null
     */
    public function getGeometry()
    {
        return $this->Geometry;
    }
    /**
     * Set Geometry value
     * @param \StructType\Geometry $geometry
     * @return \StructType\Record
     */
    public function setGeometry(\StructType\Geometry $geometry = null)
    {
        $this->Geometry = $geometry;
        return $this;
    }
    /**
     * Get Dataset value
     * @return \StructType\Dataset[]|null
     */
    public function getDataset()
    {
        return $this->Dataset;
    }
    /**
     * This method is responsible for validating the values passed to the setDataset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDataset method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatasetForArrayConstraintsFromSetDataset(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recordDatasetItem) {
            // validation for constraint: itemType
            if (!$recordDatasetItem instanceof \StructType\Dataset) {
                $invalidValues[] = is_object($recordDatasetItem) ? get_class($recordDatasetItem) : sprintf('%s(%s)', gettype($recordDatasetItem), var_export($recordDatasetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dataset property can only contain items of type \StructType\Dataset, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dataset value
     * @throws \InvalidArgumentException
     * @param \StructType\Dataset[] $dataset
     * @return \StructType\Record
     */
    public function setDataset(array $dataset = array())
    {
        // validation for constraint: array
        if ('' !== ($datasetArrayErrorMessage = self::validateDatasetForArrayConstraintsFromSetDataset($dataset))) {
            throw new \InvalidArgumentException($datasetArrayErrorMessage, __LINE__);
        }
        $this->Dataset = $dataset;
        return $this;
    }
    /**
     * Add item to Dataset value
     * @throws \InvalidArgumentException
     * @param \StructType\Dataset $item
     * @return \StructType\Record
     */
    public function addToDataset(\StructType\Dataset $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dataset) {
            throw new \InvalidArgumentException(sprintf('The Dataset property can only contain items of type \StructType\Dataset, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dataset[] = $item;
        return $this;
    }
}
