<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Index StructType
 * @subpackage Structs
 */
class Index extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The Field
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Field[]
     */
    public $Field;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $Key;
    /**
     * Constructor method for Index
     * @uses Index::setId()
     * @uses Index::setName()
     * @uses Index::setField()
     * @uses Index::setKey()
     * @param string $id
     * @param string $name
     * @param \StructType\Field[] $field
     * @param string[] $key
     */
    public function __construct($id = null, $name = null, array $field = array(), array $key = array())
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setField($field)
            ->setKey($key);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Index
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Index
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get Field value
     * @return \StructType\Field[]|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * This method is responsible for validating the values passed to the setField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldForArrayConstraintsFromSetField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $indexFieldItem) {
            // validation for constraint: itemType
            if (!$indexFieldItem instanceof \StructType\Field) {
                $invalidValues[] = is_object($indexFieldItem) ? get_class($indexFieldItem) : sprintf('%s(%s)', gettype($indexFieldItem), var_export($indexFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Field property can only contain items of type \StructType\Field, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field[] $field
     * @return \StructType\Index
     */
    public function setField(array $field = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldArrayErrorMessage = self::validateFieldForArrayConstraintsFromSetField($field))) {
            throw new \InvalidArgumentException($fieldArrayErrorMessage, __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Add item to Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field $item
     * @return \StructType\Index
     */
    public function addToField(\StructType\Field $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Field) {
            throw new \InvalidArgumentException(sprintf('The Field property can only contain items of type \StructType\Field, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Field[] = $item;
        return $this;
    }
    /**
     * Get Key value
     * @return string[]|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * This method is responsible for validating the values passed to the setKey method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKey method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyForArrayConstraintsFromSetKey(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $indexKeyItem) {
            // validation for constraint: itemType
            if (!is_string($indexKeyItem)) {
                $invalidValues[] = is_object($indexKeyItem) ? get_class($indexKeyItem) : sprintf('%s(%s)', gettype($indexKeyItem), var_export($indexKeyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Key property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Key value
     * @throws \InvalidArgumentException
     * @param string[] $key
     * @return \StructType\Index
     */
    public function setKey(array $key = array())
    {
        // validation for constraint: array
        if ('' !== ($keyArrayErrorMessage = self::validateKeyForArrayConstraintsFromSetKey($key))) {
            throw new \InvalidArgumentException($keyArrayErrorMessage, __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Add item to Key value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Index
     */
    public function addToKey($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Key property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Key[] = $item;
        return $this;
    }
}
