<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLayerDataRequest StructType
 * @subpackage Structs
 */
class GetLayerDataRequest extends AbstractStructBase
{
    /**
     * The Security
     * @var \StructType\Security2
     */
    public $Security;
    /**
     * The Layer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Layer[]
     */
    public $Layer;
    /**
     * Constructor method for GetLayerDataRequest
     * @uses GetLayerDataRequest::setSecurity()
     * @uses GetLayerDataRequest::setLayer()
     * @param \StructType\Security2 $security
     * @param \StructType\Layer[] $layer
     */
    public function __construct(\StructType\Security2 $security = null, array $layer = array())
    {
        $this
            ->setSecurity($security)
            ->setLayer($layer);
    }
    /**
     * Get Security value
     * @return \StructType\Security2|null
     */
    public function getSecurity()
    {
        return $this->Security;
    }
    /**
     * Set Security value
     * @param \StructType\Security2 $security
     * @return \StructType\GetLayerDataRequest
     */
    public function setSecurity(\StructType\Security2 $security = null)
    {
        $this->Security = $security;
        return $this;
    }
    /**
     * Get Layer value
     * @return \StructType\Layer[]|null
     */
    public function getLayer()
    {
        return $this->Layer;
    }
    /**
     * This method is responsible for validating the values passed to the setLayer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLayer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLayerForArrayConstraintsFromSetLayer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getLayerDataRequestLayerItem) {
            // validation for constraint: itemType
            if (!$getLayerDataRequestLayerItem instanceof \StructType\Layer) {
                $invalidValues[] = is_object($getLayerDataRequestLayerItem) ? get_class($getLayerDataRequestLayerItem) : sprintf('%s(%s)', gettype($getLayerDataRequestLayerItem), var_export($getLayerDataRequestLayerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Layer property can only contain items of type \StructType\Layer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Layer value
     * @throws \InvalidArgumentException
     * @param \StructType\Layer[] $layer
     * @return \StructType\GetLayerDataRequest
     */
    public function setLayer(array $layer = array())
    {
        // validation for constraint: array
        if ('' !== ($layerArrayErrorMessage = self::validateLayerForArrayConstraintsFromSetLayer($layer))) {
            throw new \InvalidArgumentException($layerArrayErrorMessage, __LINE__);
        }
        $this->Layer = $layer;
        return $this;
    }
    /**
     * Add item to Layer value
     * @throws \InvalidArgumentException
     * @param \StructType\Layer $item
     * @return \StructType\GetLayerDataRequest
     */
    public function addToLayer(\StructType\Layer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Layer) {
            throw new \InvalidArgumentException(sprintf('The Layer property can only contain items of type \StructType\Layer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Layer[] = $item;
        return $this;
    }
}
