<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Field StructType
 * @subpackage Structs
 */
class Field extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The virtual
     * @var bool
     */
    public $virtual;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * The descending
     * @var bool
     */
    public $descending;
    /**
     * The natural
     * @var bool
     */
    public $natural;
    /**
     * Constructor method for Field
     * @uses Field::setId()
     * @uses Field::setName()
     * @uses Field::setType()
     * @uses Field::setVirtual()
     * @uses Field::set_()
     * @uses Field::setOperator()
     * @uses Field::setDescending()
     * @uses Field::setNatural()
     * @param string $id
     * @param string $name
     * @param string $type
     * @param bool $virtual
     * @param string $_
     * @param string $operator
     * @param bool $descending
     * @param bool $natural
     */
    public function __construct($id = null, $name = null, $type = null, $virtual = null, $_ = null, $operator = null, $descending = null, $natural = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setType($type)
            ->setVirtual($virtual)
            ->set_($_)
            ->setOperator($operator)
            ->setDescending($descending)
            ->setNatural($natural);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Field
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Field
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Field
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get virtual value
     * @return bool|null
     */
    public function getVirtual()
    {
        return $this->virtual;
    }
    /**
     * Set virtual value
     * @param bool $virtual
     * @return \StructType\Field
     */
    public function setVirtual($virtual = null)
    {
        // validation for constraint: boolean
        if (!is_null($virtual) && !is_bool($virtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($virtual, true), gettype($virtual)), __LINE__);
        }
        $this->virtual = $virtual;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Field
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\Operator::valueIsValid()
     * @uses \EnumType\Operator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\Field
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Operator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Operator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\Operator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get descending value
     * @return bool|null
     */
    public function getDescending()
    {
        return $this->descending;
    }
    /**
     * Set descending value
     * @param bool $descending
     * @return \StructType\Field
     */
    public function setDescending($descending = null)
    {
        // validation for constraint: boolean
        if (!is_null($descending) && !is_bool($descending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($descending, true), gettype($descending)), __LINE__);
        }
        $this->descending = $descending;
        return $this;
    }
    /**
     * Get natural value
     * @return bool|null
     */
    public function getNatural()
    {
        return $this->natural;
    }
    /**
     * Set natural value
     * @param bool $natural
     * @return \StructType\Field
     */
    public function setNatural($natural = null)
    {
        // validation for constraint: boolean
        if (!is_null($natural) && !is_bool($natural)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($natural, true), gettype($natural)), __LINE__);
        }
        $this->natural = $natural;
        return $this;
    }
}
