<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionRequest $parameters
     * @return \StructType\GetSessionResponse|bool
     */
    public function GetSession(\StructType\GetSessionRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLayerList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLayerListRequest $parameters
     * @return \StructType\GetLayerListResponse|bool
     */
    public function GetLayerList(\StructType\GetLayerListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLayerList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLayerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLayerInfoRequest $parameters
     * @return \StructType\GetLayerInfoResponse|bool
     */
    public function GetLayerInfo(\StructType\GetLayerInfoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLayerInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLayerData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLayerDataRequest $parameters
     * @return \StructType\GetLayerDataResponse|bool
     */
    public function GetLayerData(\StructType\GetLayerDataRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLayerData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetLayerDataResponse|\StructType\GetLayerInfoResponse|\StructType\GetLayerListResponse|\StructType\GetSessionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
