<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for srs EnumType
 * @subpackage Enumerations
 */
class Srs extends AbstractStructEnumBase
{
    /**
     * Constant for value 'EPSG:4326'
     * @return string 'EPSG:4326'
     */
    const VALUE_EPSG_4326 = 'EPSG:4326';
    /**
     * Constant for value 'EPSG:3912'
     * @return string 'EPSG:3912'
     */
    const VALUE_EPSG_3912 = 'EPSG:3912';
    /**
     * Constant for value 'EPSG:3794'
     * @return string 'EPSG:3794'
     */
    const VALUE_EPSG_3794 = 'EPSG:3794';
    /**
     * Constant for value 'EPSG:3857'
     * @return string 'EPSG:3857'
     */
    const VALUE_EPSG_3857 = 'EPSG:3857';
    /**
     * Return allowed values
     * @uses self::VALUE_EPSG_4326
     * @uses self::VALUE_EPSG_3912
     * @uses self::VALUE_EPSG_3794
     * @uses self::VALUE_EPSG_3857
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EPSG_4326,
            self::VALUE_EPSG_3912,
            self::VALUE_EPSG_3794,
            self::VALUE_EPSG_3857,
        );
    }
}
