<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for operator EnumType
 * @subpackage Enumerations
 */
class Operator extends AbstractStructEnumBase
{
    /**
     * Constant for value 'eq'
     * @return string 'eq'
     */
    const VALUE_EQ = 'eq';
    /**
     * Constant for value 'ne'
     * @return string 'ne'
     */
    const VALUE_NE = 'ne';
    /**
     * Constant for value 'lt'
     * @return string 'lt'
     */
    const VALUE_LT = 'lt';
    /**
     * Constant for value 'le'
     * @return string 'le'
     */
    const VALUE_LE = 'le';
    /**
     * Constant for value 'gt'
     * @return string 'gt'
     */
    const VALUE_GT = 'gt';
    /**
     * Constant for value 'ge'
     * @return string 'ge'
     */
    const VALUE_GE = 'ge';
    /**
     * Constant for value 'like'
     * @return string 'like'
     */
    const VALUE_LIKE = 'like';
    /**
     * Constant for value 'match'
     * @return string 'match'
     */
    const VALUE_MATCH = 'match';
    /**
     * Return allowed values
     * @uses self::VALUE_EQ
     * @uses self::VALUE_NE
     * @uses self::VALUE_LT
     * @uses self::VALUE_LE
     * @uses self::VALUE_GT
     * @uses self::VALUE_GE
     * @uses self::VALUE_LIKE
     * @uses self::VALUE_MATCH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQ,
            self::VALUE_NE,
            self::VALUE_LT,
            self::VALUE_LE,
            self::VALUE_GT,
            self::VALUE_GE,
            self::VALUE_LIKE,
            self::VALUE_MATCH,
        );
    }
}
