<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchRequest
 * @subpackage Structs
 */
class SearchRequest extends BaseRequest
{
    /**
     * The PackageSearchType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageSearchType;
    /**
     * Constructor method for SearchRequest
     * @uses SearchRequest::setPackageSearchType()
     * @param string $packageSearchType
     */
    public function __construct($packageSearchType = null)
    {
        $this
            ->setPackageSearchType($packageSearchType);
    }
    /**
     * Get PackageSearchType value
     * @return string|null
     */
    public function getPackageSearchType()
    {
        return $this->PackageSearchType;
    }
    /**
     * Set PackageSearchType value
     * @uses \TravelAccess\EnumType\PackageSearchType::valueIsValid()
     * @uses \TravelAccess\EnumType\PackageSearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packageSearchType
     * @return \TravelAccess\StructType\SearchRequest
     */
    public function setPackageSearchType($packageSearchType = null)
    {
        // validation for constraint: enumeration
        if (!\TravelAccess\EnumType\PackageSearchType::valueIsValid($packageSearchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packageSearchType, implode(', ', \TravelAccess\EnumType\PackageSearchType::getValidValues())), __LINE__);
        }
        $this->PackageSearchType = $packageSearchType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\SearchRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
