<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSearchRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q5:FlightSearchRequest
 * @subpackage Structs
 */
class FlightSearchRequest extends SearchRequest
{
    /**
     * The OrderBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * The SearchLegs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfFlightSearchLeg
     */
    public $SearchLegs;
    /**
     * The SearchPassengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfSearchPassenger
     */
    public $SearchPassengers;
    /**
     * Constructor method for FlightSearchRequest
     * @uses FlightSearchRequest::setOrderBy()
     * @uses FlightSearchRequest::setSearchLegs()
     * @uses FlightSearchRequest::setSearchPassengers()
     * @param string $orderBy
     * @param \TravelAccess\ArrayType\ArrayOfFlightSearchLeg $searchLegs
     * @param \TravelAccess\ArrayType\ArrayOfSearchPassenger $searchPassengers
     */
    public function __construct($orderBy = null, \TravelAccess\ArrayType\ArrayOfFlightSearchLeg $searchLegs = null, \TravelAccess\ArrayType\ArrayOfSearchPassenger $searchPassengers = null)
    {
        $this
            ->setOrderBy($orderBy)
            ->setSearchLegs($searchLegs)
            ->setSearchPassengers($searchPassengers);
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @uses \TravelAccess\EnumType\FlightSearchOrderBy::valueIsValid()
     * @uses \TravelAccess\EnumType\FlightSearchOrderBy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderBy
     * @return \TravelAccess\StructType\FlightSearchRequest
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: enumeration
        if (!\TravelAccess\EnumType\FlightSearchOrderBy::valueIsValid($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderBy, implode(', ', \TravelAccess\EnumType\FlightSearchOrderBy::getValidValues())), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
    /**
     * Get SearchLegs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfFlightSearchLeg|null
     */
    public function getSearchLegs()
    {
        return isset($this->SearchLegs) ? $this->SearchLegs : null;
    }
    /**
     * Set SearchLegs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfFlightSearchLeg $searchLegs
     * @return \TravelAccess\StructType\FlightSearchRequest
     */
    public function setSearchLegs(\TravelAccess\ArrayType\ArrayOfFlightSearchLeg $searchLegs = null)
    {
        if (is_null($searchLegs) || (is_array($searchLegs) && empty($searchLegs))) {
            unset($this->SearchLegs);
        } else {
            $this->SearchLegs = $searchLegs;
        }
        return $this;
    }
    /**
     * Get SearchPassengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfSearchPassenger|null
     */
    public function getSearchPassengers()
    {
        return isset($this->SearchPassengers) ? $this->SearchPassengers : null;
    }
    /**
     * Set SearchPassengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfSearchPassenger $searchPassengers
     * @return \TravelAccess\StructType\FlightSearchRequest
     */
    public function setSearchPassengers(\TravelAccess\ArrayType\ArrayOfSearchPassenger $searchPassengers = null)
    {
        if (is_null($searchPassengers) || (is_array($searchPassengers) && empty($searchPassengers))) {
            unset($this->SearchPassengers);
        } else {
            $this->SearchPassengers = $searchPassengers;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\FlightSearchRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
