<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingRecordOfPricingCombination StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BookingRecordOfPricingCombination
 * @subpackage Structs
 */
class BookingRecordOfPricingCombination extends AbstractStructBase
{
    /**
     * The BookingKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingKey;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The PassengerProducts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfPassengerProduct
     */
    public $PassengerProducts;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\PricingCombination
     */
    public $Product;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Version;
    /**
     * Constructor method for BookingRecordOfPricingCombination
     * @uses BookingRecordOfPricingCombination::setBookingKey()
     * @uses BookingRecordOfPricingCombination::setCreateDate()
     * @uses BookingRecordOfPricingCombination::setPassengerProducts()
     * @uses BookingRecordOfPricingCombination::setProduct()
     * @uses BookingRecordOfPricingCombination::setVersion()
     * @param string $bookingKey
     * @param string $createDate
     * @param \TravelAccess\ArrayType\ArrayOfPassengerProduct $passengerProducts
     * @param \TravelAccess\StructType\PricingCombination $product
     * @param int $version
     */
    public function __construct($bookingKey = null, $createDate = null, \TravelAccess\ArrayType\ArrayOfPassengerProduct $passengerProducts = null, \TravelAccess\StructType\PricingCombination $product = null, $version = null)
    {
        $this
            ->setBookingKey($bookingKey)
            ->setCreateDate($createDate)
            ->setPassengerProducts($passengerProducts)
            ->setProduct($product)
            ->setVersion($version);
    }
    /**
     * Get BookingKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingKey()
    {
        return isset($this->BookingKey) ? $this->BookingKey : null;
    }
    /**
     * Set BookingKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingKey
     * @return \TravelAccess\StructType\BookingRecordOfPricingCombination
     */
    public function setBookingKey($bookingKey = null)
    {
        // validation for constraint: string
        if (!is_null($bookingKey) && !is_string($bookingKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingKey)), __LINE__);
        }
        if (is_null($bookingKey) || (is_array($bookingKey) && empty($bookingKey))) {
            unset($this->BookingKey);
        } else {
            $this->BookingKey = $bookingKey;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \TravelAccess\StructType\BookingRecordOfPricingCombination
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get PassengerProducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfPassengerProduct|null
     */
    public function getPassengerProducts()
    {
        return isset($this->PassengerProducts) ? $this->PassengerProducts : null;
    }
    /**
     * Set PassengerProducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfPassengerProduct $passengerProducts
     * @return \TravelAccess\StructType\BookingRecordOfPricingCombination
     */
    public function setPassengerProducts(\TravelAccess\ArrayType\ArrayOfPassengerProduct $passengerProducts = null)
    {
        if (is_null($passengerProducts) || (is_array($passengerProducts) && empty($passengerProducts))) {
            unset($this->PassengerProducts);
        } else {
            $this->PassengerProducts = $passengerProducts;
        }
        return $this;
    }
    /**
     * Get Product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\PricingCombination|null
     */
    public function getProduct()
    {
        return isset($this->Product) ? $this->Product : null;
    }
    /**
     * Set Product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\PricingCombination $product
     * @return \TravelAccess\StructType\BookingRecordOfPricingCombination
     */
    public function setProduct(\TravelAccess\StructType\PricingCombination $product = null)
    {
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->Product);
        } else {
            $this->Product = $product;
        }
        return $this;
    }
    /**
     * Get Version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param int $version
     * @return \TravelAccess\StructType\BookingRecordOfPricingCombination
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\BookingRecordOfPricingCombination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
