<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseRequest
 * @subpackage Structs
 */
class BaseRequest extends AbstractStructBase
{
    /**
     * The ReturnDiagnostics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReturnDiagnostics;
    /**
     * The TraceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TraceId;
    /**
     * Constructor method for BaseRequest
     * @uses BaseRequest::setReturnDiagnostics()
     * @uses BaseRequest::setTraceId()
     * @param string $returnDiagnostics
     * @param string $traceId
     */
    public function __construct($returnDiagnostics = null, $traceId = null)
    {
        $this
            ->setReturnDiagnostics($returnDiagnostics)
            ->setTraceId($traceId);
    }
    /**
     * Get ReturnDiagnostics value
     * @return string|null
     */
    public function getReturnDiagnostics()
    {
        return $this->ReturnDiagnostics;
    }
    /**
     * Set ReturnDiagnostics value
     * @uses \TravelAccess\EnumType\ReturnDiagnosticsFlags::valueIsValid()
     * @uses \TravelAccess\EnumType\ReturnDiagnosticsFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $returnDiagnostics
     * @return \TravelAccess\StructType\BaseRequest
     */
    public function setReturnDiagnostics($returnDiagnostics = null)
    {
        // validation for constraint: enumeration
        if (!\TravelAccess\EnumType\ReturnDiagnosticsFlags::valueIsValid($returnDiagnostics)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $returnDiagnostics, implode(', ', \TravelAccess\EnumType\ReturnDiagnosticsFlags::getValidValues())), __LINE__);
        }
        $this->ReturnDiagnostics = $returnDiagnostics;
        return $this;
    }
    /**
     * Get TraceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTraceId()
    {
        return isset($this->TraceId) ? $this->TraceId : null;
    }
    /**
     * Set TraceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $traceId
     * @return \TravelAccess\StructType\BaseRequest
     */
    public function setTraceId($traceId = null)
    {
        // validation for constraint: string
        if (!is_null($traceId) && !is_string($traceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceId)), __LINE__);
        }
        if (is_null($traceId) || (is_array($traceId) && empty($traceId))) {
            unset($this->TraceId);
        } else {
            $this->TraceId = $traceId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\BaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
