<?php

namespace TravelAccess\EnumType;

/**
 * This class stands for RecordStatus EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RecordStatus
 * @subpackage Enumerations
 */
class RecordStatus
{
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Booked'
     * @return string 'Booked'
     */
    const VALUE_BOOKED = 'Booked';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_BOOKED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CANCELED,
            self::VALUE_ACTIVE,
            self::VALUE_BOOKED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
