<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegmentCoupon StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q71:FlightSegmentCoupon
 * @subpackage Structs
 */
class FlightSegmentCoupon extends FlightSegment
{
    /**
     * The BaggageQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaggageQuantity;
    /**
     * The BaggageWeightUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaggageWeightUnit;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasis;
    /**
     * The NotValidAfter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NotValidAfter;
    /**
     * The NotValidBefore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NotValidBefore;
    /**
     * Constructor method for FlightSegmentCoupon
     * @uses FlightSegmentCoupon::setBaggageQuantity()
     * @uses FlightSegmentCoupon::setBaggageWeightUnit()
     * @uses FlightSegmentCoupon::setFareBasis()
     * @uses FlightSegmentCoupon::setNotValidAfter()
     * @uses FlightSegmentCoupon::setNotValidBefore()
     * @param float $baggageQuantity
     * @param string $baggageWeightUnit
     * @param string $fareBasis
     * @param string $notValidAfter
     * @param string $notValidBefore
     */
    public function __construct($baggageQuantity = null, $baggageWeightUnit = null, $fareBasis = null, $notValidAfter = null, $notValidBefore = null)
    {
        $this
            ->setBaggageQuantity($baggageQuantity)
            ->setBaggageWeightUnit($baggageWeightUnit)
            ->setFareBasis($fareBasis)
            ->setNotValidAfter($notValidAfter)
            ->setNotValidBefore($notValidBefore);
    }
    /**
     * Get BaggageQuantity value
     * @return float|null
     */
    public function getBaggageQuantity()
    {
        return $this->BaggageQuantity;
    }
    /**
     * Set BaggageQuantity value
     * @param float $baggageQuantity
     * @return \TravelAccess\StructType\FlightSegmentCoupon
     */
    public function setBaggageQuantity($baggageQuantity = null)
    {
        $this->BaggageQuantity = $baggageQuantity;
        return $this;
    }
    /**
     * Get BaggageWeightUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaggageWeightUnit()
    {
        return isset($this->BaggageWeightUnit) ? $this->BaggageWeightUnit : null;
    }
    /**
     * Set BaggageWeightUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baggageWeightUnit
     * @return \TravelAccess\StructType\FlightSegmentCoupon
     */
    public function setBaggageWeightUnit($baggageWeightUnit = null)
    {
        // validation for constraint: string
        if (!is_null($baggageWeightUnit) && !is_string($baggageWeightUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baggageWeightUnit)), __LINE__);
        }
        if (is_null($baggageWeightUnit) || (is_array($baggageWeightUnit) && empty($baggageWeightUnit))) {
            unset($this->BaggageWeightUnit);
        } else {
            $this->BaggageWeightUnit = $baggageWeightUnit;
        }
        return $this;
    }
    /**
     * Get FareBasis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasis()
    {
        return isset($this->FareBasis) ? $this->FareBasis : null;
    }
    /**
     * Set FareBasis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasis
     * @return \TravelAccess\StructType\FlightSegmentCoupon
     */
    public function setFareBasis($fareBasis = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasis) && !is_string($fareBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasis)), __LINE__);
        }
        if (is_null($fareBasis) || (is_array($fareBasis) && empty($fareBasis))) {
            unset($this->FareBasis);
        } else {
            $this->FareBasis = $fareBasis;
        }
        return $this;
    }
    /**
     * Get NotValidAfter value
     * @return string|null
     */
    public function getNotValidAfter()
    {
        return $this->NotValidAfter;
    }
    /**
     * Set NotValidAfter value
     * @param string $notValidAfter
     * @return \TravelAccess\StructType\FlightSegmentCoupon
     */
    public function setNotValidAfter($notValidAfter = null)
    {
        // validation for constraint: string
        if (!is_null($notValidAfter) && !is_string($notValidAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notValidAfter)), __LINE__);
        }
        $this->NotValidAfter = $notValidAfter;
        return $this;
    }
    /**
     * Get NotValidBefore value
     * @return string|null
     */
    public function getNotValidBefore()
    {
        return $this->NotValidBefore;
    }
    /**
     * Set NotValidBefore value
     * @param string $notValidBefore
     * @return \TravelAccess\StructType\FlightSegmentCoupon
     */
    public function setNotValidBefore($notValidBefore = null)
    {
        // validation for constraint: string
        if (!is_null($notValidBefore) && !is_string($notValidBefore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notValidBefore)), __LINE__);
        }
        $this->NotValidBefore = $notValidBefore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\FlightSegmentCoupon
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
