<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightPassengerProduct StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q67:FlightPassengerProduct
 * @subpackage Structs
 */
class FlightPassengerProduct extends PassengerProduct
{
    /**
     * The ControlNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ControlNumber;
    /**
     * The Coupons
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfFlightSegmentCoupon
     */
    public $Coupons;
    /**
     * The ETicketNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ETicketNumber;
    /**
     * The IataNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IataNumber;
    /**
     * The IssuingAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Airline
     */
    public $IssuingAirline;
    /**
     * Constructor method for FlightPassengerProduct
     * @uses FlightPassengerProduct::setControlNumber()
     * @uses FlightPassengerProduct::setCoupons()
     * @uses FlightPassengerProduct::setETicketNumber()
     * @uses FlightPassengerProduct::setIataNumber()
     * @uses FlightPassengerProduct::setIssuingAirline()
     * @param string $controlNumber
     * @param \TravelAccess\ArrayType\ArrayOfFlightSegmentCoupon $coupons
     * @param string $eTicketNumber
     * @param string $iataNumber
     * @param \TravelAccess\StructType\Airline $issuingAirline
     */
    public function __construct($controlNumber = null, \TravelAccess\ArrayType\ArrayOfFlightSegmentCoupon $coupons = null, $eTicketNumber = null, $iataNumber = null, \TravelAccess\StructType\Airline $issuingAirline = null)
    {
        $this
            ->setControlNumber($controlNumber)
            ->setCoupons($coupons)
            ->setETicketNumber($eTicketNumber)
            ->setIataNumber($iataNumber)
            ->setIssuingAirline($issuingAirline);
    }
    /**
     * Get ControlNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getControlNumber()
    {
        return isset($this->ControlNumber) ? $this->ControlNumber : null;
    }
    /**
     * Set ControlNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $controlNumber
     * @return \TravelAccess\StructType\FlightPassengerProduct
     */
    public function setControlNumber($controlNumber = null)
    {
        // validation for constraint: string
        if (!is_null($controlNumber) && !is_string($controlNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controlNumber)), __LINE__);
        }
        if (is_null($controlNumber) || (is_array($controlNumber) && empty($controlNumber))) {
            unset($this->ControlNumber);
        } else {
            $this->ControlNumber = $controlNumber;
        }
        return $this;
    }
    /**
     * Get Coupons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfFlightSegmentCoupon|null
     */
    public function getCoupons()
    {
        return isset($this->Coupons) ? $this->Coupons : null;
    }
    /**
     * Set Coupons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfFlightSegmentCoupon $coupons
     * @return \TravelAccess\StructType\FlightPassengerProduct
     */
    public function setCoupons(\TravelAccess\ArrayType\ArrayOfFlightSegmentCoupon $coupons = null)
    {
        if (is_null($coupons) || (is_array($coupons) && empty($coupons))) {
            unset($this->Coupons);
        } else {
            $this->Coupons = $coupons;
        }
        return $this;
    }
    /**
     * Get ETicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getETicketNumber()
    {
        return isset($this->ETicketNumber) ? $this->ETicketNumber : null;
    }
    /**
     * Set ETicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eTicketNumber
     * @return \TravelAccess\StructType\FlightPassengerProduct
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eTicketNumber) && !is_string($eTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eTicketNumber)), __LINE__);
        }
        if (is_null($eTicketNumber) || (is_array($eTicketNumber) && empty($eTicketNumber))) {
            unset($this->ETicketNumber);
        } else {
            $this->ETicketNumber = $eTicketNumber;
        }
        return $this;
    }
    /**
     * Get IataNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIataNumber()
    {
        return isset($this->IataNumber) ? $this->IataNumber : null;
    }
    /**
     * Set IataNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iataNumber
     * @return \TravelAccess\StructType\FlightPassengerProduct
     */
    public function setIataNumber($iataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumber) && !is_string($iataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iataNumber)), __LINE__);
        }
        if (is_null($iataNumber) || (is_array($iataNumber) && empty($iataNumber))) {
            unset($this->IataNumber);
        } else {
            $this->IataNumber = $iataNumber;
        }
        return $this;
    }
    /**
     * Get IssuingAirline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Airline|null
     */
    public function getIssuingAirline()
    {
        return isset($this->IssuingAirline) ? $this->IssuingAirline : null;
    }
    /**
     * Set IssuingAirline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Airline $issuingAirline
     * @return \TravelAccess\StructType\FlightPassengerProduct
     */
    public function setIssuingAirline(\TravelAccess\StructType\Airline $issuingAirline = null)
    {
        if (is_null($issuingAirline) || (is_array($issuingAirline) && empty($issuingAirline))) {
            unset($this->IssuingAirline);
        } else {
            $this->IssuingAirline = $issuingAirline;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\FlightPassengerProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
