<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DetailRequest
 * @subpackage Structs
 */
class DetailRequest extends BaseRequest
{
    /**
     * The ProductKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductKey;
    /**
     * The ProductKeys
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfstring
     */
    public $ProductKeys;
    /**
     * Constructor method for DetailRequest
     * @uses DetailRequest::setProductKey()
     * @uses DetailRequest::setProductKeys()
     * @param string $productKey
     * @param \TravelAccess\ArrayType\ArrayOfstring $productKeys
     */
    public function __construct($productKey = null, \TravelAccess\ArrayType\ArrayOfstring $productKeys = null)
    {
        $this
            ->setProductKey($productKey)
            ->setProductKeys($productKeys);
    }
    /**
     * Get ProductKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductKey()
    {
        return isset($this->ProductKey) ? $this->ProductKey : null;
    }
    /**
     * Set ProductKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productKey
     * @return \TravelAccess\StructType\DetailRequest
     */
    public function setProductKey($productKey = null)
    {
        // validation for constraint: string
        if (!is_null($productKey) && !is_string($productKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productKey)), __LINE__);
        }
        if (is_null($productKey) || (is_array($productKey) && empty($productKey))) {
            unset($this->ProductKey);
        } else {
            $this->ProductKey = $productKey;
        }
        return $this;
    }
    /**
     * Get ProductKeys value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfstring|null
     */
    public function getProductKeys()
    {
        return isset($this->ProductKeys) ? $this->ProductKeys : null;
    }
    /**
     * Set ProductKeys value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfstring $productKeys
     * @return \TravelAccess\StructType\DetailRequest
     */
    public function setProductKeys(\TravelAccess\ArrayType\ArrayOfstring $productKeys = null)
    {
        if (is_null($productKeys) || (is_array($productKeys) && empty($productKeys))) {
            unset($this->ProductKeys);
        } else {
            $this->ProductKeys = $productKeys;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\DetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
