<?php

namespace TravelAccess\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reserve ServiceType
 * @subpackage Services
 */
class Reserve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Reserve
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TravelAccess\StructType\Reserve $parameters
     * @return \TravelAccess\StructType\ReserveResponse|bool
     */
    public function Reserve(\TravelAccess\StructType\Reserve $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Reserve($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TravelAccess\StructType\ReserveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
