<?php

namespace TravelAccess\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAirline ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q16:ArrayOfAirline
 * @subpackage Arrays
 */
class ArrayOfAirline extends AbstractStructArrayBase
{
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Airline[]
     */
    public $Airline;
    /**
     * Constructor method for ArrayOfAirline
     * @uses ArrayOfAirline::setAirline()
     * @param \TravelAccess\StructType\Airline[] $airline
     */
    public function __construct(array $airline = array())
    {
        $this
            ->setAirline($airline);
    }
    /**
     * Get Airline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Airline[]|null
     */
    public function getAirline()
    {
        return isset($this->Airline) ? $this->Airline : null;
    }
    /**
     * Set Airline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\Airline[] $airline
     * @return \TravelAccess\ArrayType\ArrayOfAirline
     */
    public function setAirline(array $airline = array())
    {
        foreach ($airline as $arrayOfAirlineAirlineItem) {
            // validation for constraint: itemType
            if (!$arrayOfAirlineAirlineItem instanceof \TravelAccess\StructType\Airline) {
                throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of \TravelAccess\StructType\Airline, "%s" given', is_object($arrayOfAirlineAirlineItem) ? get_class($arrayOfAirlineAirlineItem) : gettype($arrayOfAirlineAirlineItem)), __LINE__);
            }
        }
        if (is_null($airline) || (is_array($airline) && empty($airline))) {
            unset($this->Airline);
        } else {
            $this->Airline = $airline;
        }
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\Airline $item
     * @return \TravelAccess\ArrayType\ArrayOfAirline
     */
    public function addToAirline(\TravelAccess\StructType\Airline $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TravelAccess\StructType\Airline) {
            throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of \TravelAccess\StructType\Airline, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Airline[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TravelAccess\StructType\Airline|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TravelAccess\StructType\Airline|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TravelAccess\StructType\Airline|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TravelAccess\StructType\Airline|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TravelAccess\StructType\Airline|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Airline
     */
    public function getAttributeName()
    {
        return 'Airline';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\ArrayType\ArrayOfAirline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
