<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedicalReportWithoutFilesType Struct
 * Meta information extracted from the WSDL
 * - documentation: Реквизиты документа, подтверждающего группу коменсирующей направленности
 * @subpackage Structs
 */
class MedicalReportWithoutFilesType extends AbstractStructBase
{
    /**
     * The DocName
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $DocName;
    /**
     * The DocSeries
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $DocSeries;
    /**
     * The DocNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * @var string
     */
    public $DocNumber;
    /**
     * The DocIssueDate
     * @var string
     */
    public $DocIssueDate;
    /**
     * The DocIssued
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $DocIssued;
    /**
     * The DocExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocExpirationDate;
    /**
     * Constructor method for MedicalReportWithoutFilesType
     * @uses MedicalReportWithoutFilesType::setDocName()
     * @uses MedicalReportWithoutFilesType::setDocSeries()
     * @uses MedicalReportWithoutFilesType::setDocNumber()
     * @uses MedicalReportWithoutFilesType::setDocIssueDate()
     * @uses MedicalReportWithoutFilesType::setDocIssued()
     * @uses MedicalReportWithoutFilesType::setDocExpirationDate()
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $docName
     * @param string $docSeries
     * @param string $docNumber
     * @param string $docIssueDate
     * @param string $docIssued
     * @param string $docExpirationDate
     */
    public function __construct(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $docName = null, $docSeries = null, $docNumber = null, $docIssueDate = null, $docIssued = null, $docExpirationDate = null)
    {
        $this
            ->setDocName($docName)
            ->setDocSeries($docSeries)
            ->setDocNumber($docNumber)
            ->setDocIssueDate($docIssueDate)
            ->setDocIssued($docIssued)
            ->setDocExpirationDate($docExpirationDate);
    }
    /**
     * Get DocName value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getDocName()
    {
        return $this->DocName;
    }
    /**
     * Set DocName value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $docName
     * @return \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType
     */
    public function setDocName(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $docName = null)
    {
        $this->DocName = $docName;
        return $this;
    }
    /**
     * Get DocSeries value
     * @return string|null
     */
    public function getDocSeries()
    {
        return $this->DocSeries;
    }
    /**
     * Set DocSeries value
     * @param string $docSeries
     * @return \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType
     */
    public function setDocSeries($docSeries = null)
    {
        // validation for constraint: string
        if (!is_null($docSeries) && !is_string($docSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docSeries, true), gettype($docSeries)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($docSeries) && mb_strlen($docSeries) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($docSeries)), __LINE__);
        }
        $this->DocSeries = $docSeries;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($docNumber) && mb_strlen($docNumber) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocIssueDate value
     * @return string|null
     */
    public function getDocIssueDate()
    {
        return $this->DocIssueDate;
    }
    /**
     * Set DocIssueDate value
     * @param string $docIssueDate
     * @return \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType
     */
    public function setDocIssueDate($docIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueDate) && !is_string($docIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueDate, true), gettype($docIssueDate)), __LINE__);
        }
        $this->DocIssueDate = $docIssueDate;
        return $this;
    }
    /**
     * Get DocIssued value
     * @return string|null
     */
    public function getDocIssued()
    {
        return $this->DocIssued;
    }
    /**
     * Set DocIssued value
     * @param string $docIssued
     * @return \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType
     */
    public function setDocIssued($docIssued = null)
    {
        // validation for constraint: string
        if (!is_null($docIssued) && !is_string($docIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssued, true), gettype($docIssued)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($docIssued) && mb_strlen($docIssued) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($docIssued)), __LINE__);
        }
        $this->DocIssued = $docIssued;
        return $this;
    }
    /**
     * Get DocExpirationDate value
     * @return string|null
     */
    public function getDocExpirationDate()
    {
        return $this->DocExpirationDate;
    }
    /**
     * Set DocExpirationDate value
     * @param string $docExpirationDate
     * @return \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType
     */
    public function setDocExpirationDate($docExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($docExpirationDate) && !is_string($docExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docExpirationDate, true), gettype($docExpirationDate)), __LINE__);
        }
        $this->DocExpirationDate = $docExpirationDate;
        return $this;
    }
}
