<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetApplicationQueueReasonRequestType Struct
 * Meta information extracted from the WSDL
 * - documentation: Получение информации об основаниях изменений последовательности
 * @subpackage Structs
 */
class GetApplicationQueueReasonRequestType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The PeriodStart
     * @var string
     */
    public $PeriodStart;
    /**
     * The PeriodEnd
     * @var string
     */
    public $PeriodEnd;
    /**
     * Constructor method for GetApplicationQueueReasonRequestType
     * @uses GetApplicationQueueReasonRequestType::setOrderId()
     * @uses GetApplicationQueueReasonRequestType::setPeriodStart()
     * @uses GetApplicationQueueReasonRequestType::setPeriodEnd()
     * @param int $orderId
     * @param string $periodStart
     * @param string $periodEnd
     */
    public function __construct($orderId = null, $periodStart = null, $periodEnd = null)
    {
        $this
            ->setOrderId($orderId)
            ->setPeriodStart($periodStart)
            ->setPeriodEnd($periodEnd);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationQueueReasonRequestType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get PeriodStart value
     * @return string|null
     */
    public function getPeriodStart()
    {
        return $this->PeriodStart;
    }
    /**
     * Set PeriodStart value
     * @param string $periodStart
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationQueueReasonRequestType
     */
    public function setPeriodStart($periodStart = null)
    {
        // validation for constraint: string
        if (!is_null($periodStart) && !is_string($periodStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodStart, true), gettype($periodStart)), __LINE__);
        }
        $this->PeriodStart = $periodStart;
        return $this;
    }
    /**
     * Get PeriodEnd value
     * @return string|null
     */
    public function getPeriodEnd()
    {
        return $this->PeriodEnd;
    }
    /**
     * Set PeriodEnd value
     * @param string $periodEnd
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationQueueReasonRequestType
     */
    public function setPeriodEnd($periodEnd = null)
    {
        // validation for constraint: string
        if (!is_null($periodEnd) && !is_string($periodEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodEnd, true), gettype($periodEnd)), __LINE__);
        }
        $this->PeriodEnd = $periodEnd;
        return $this;
    }
}
