<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChildBirthDocRFType Struct
 * Meta information extracted from the WSDL
 * - documentation: Свидетельство о рождении РФ
 * @subpackage Structs
 */
class ChildBirthDocRFType extends AbstractStructBase
{
    /**
     * The ChildBirthDocSeries
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $ChildBirthDocSeries;
    /**
     * The ChildBirthDocNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $ChildBirthDocNumber;
    /**
     * The ChildBirthDocIssueDate
     * @var string
     */
    public $ChildBirthDocIssueDate;
    /**
     * The ChildBirthDocActNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 21
     * @var string
     */
    public $ChildBirthDocActNumber;
    /**
     * The ChildBirthDocActDate
     * @var string
     */
    public $ChildBirthDocActDate;
    /**
     * The ChildBirthDocIssued
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $ChildBirthDocIssued;
    /**
     * Constructor method for ChildBirthDocRFType
     * @uses ChildBirthDocRFType::setChildBirthDocSeries()
     * @uses ChildBirthDocRFType::setChildBirthDocNumber()
     * @uses ChildBirthDocRFType::setChildBirthDocIssueDate()
     * @uses ChildBirthDocRFType::setChildBirthDocActNumber()
     * @uses ChildBirthDocRFType::setChildBirthDocActDate()
     * @uses ChildBirthDocRFType::setChildBirthDocIssued()
     * @param string $childBirthDocSeries
     * @param string $childBirthDocNumber
     * @param string $childBirthDocIssueDate
     * @param string $childBirthDocActNumber
     * @param string $childBirthDocActDate
     * @param string $childBirthDocIssued
     */
    public function __construct($childBirthDocSeries = null, $childBirthDocNumber = null, $childBirthDocIssueDate = null, $childBirthDocActNumber = null, $childBirthDocActDate = null, $childBirthDocIssued = null)
    {
        $this
            ->setChildBirthDocSeries($childBirthDocSeries)
            ->setChildBirthDocNumber($childBirthDocNumber)
            ->setChildBirthDocIssueDate($childBirthDocIssueDate)
            ->setChildBirthDocActNumber($childBirthDocActNumber)
            ->setChildBirthDocActDate($childBirthDocActDate)
            ->setChildBirthDocIssued($childBirthDocIssued);
    }
    /**
     * Get ChildBirthDocSeries value
     * @return string|null
     */
    public function getChildBirthDocSeries()
    {
        return $this->ChildBirthDocSeries;
    }
    /**
     * Set ChildBirthDocSeries value
     * @param string $childBirthDocSeries
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChildBirthDocRFType
     */
    public function setChildBirthDocSeries($childBirthDocSeries = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocSeries) && !is_string($childBirthDocSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocSeries, true), gettype($childBirthDocSeries)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($childBirthDocSeries) && mb_strlen($childBirthDocSeries) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($childBirthDocSeries)), __LINE__);
        }
        $this->ChildBirthDocSeries = $childBirthDocSeries;
        return $this;
    }
    /**
     * Get ChildBirthDocNumber value
     * @return string|null
     */
    public function getChildBirthDocNumber()
    {
        return $this->ChildBirthDocNumber;
    }
    /**
     * Set ChildBirthDocNumber value
     * @param string $childBirthDocNumber
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChildBirthDocRFType
     */
    public function setChildBirthDocNumber($childBirthDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocNumber) && !is_string($childBirthDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocNumber, true), gettype($childBirthDocNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($childBirthDocNumber) && mb_strlen($childBirthDocNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($childBirthDocNumber)), __LINE__);
        }
        $this->ChildBirthDocNumber = $childBirthDocNumber;
        return $this;
    }
    /**
     * Get ChildBirthDocIssueDate value
     * @return string|null
     */
    public function getChildBirthDocIssueDate()
    {
        return $this->ChildBirthDocIssueDate;
    }
    /**
     * Set ChildBirthDocIssueDate value
     * @param string $childBirthDocIssueDate
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChildBirthDocRFType
     */
    public function setChildBirthDocIssueDate($childBirthDocIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocIssueDate) && !is_string($childBirthDocIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocIssueDate, true), gettype($childBirthDocIssueDate)), __LINE__);
        }
        $this->ChildBirthDocIssueDate = $childBirthDocIssueDate;
        return $this;
    }
    /**
     * Get ChildBirthDocActNumber value
     * @return string|null
     */
    public function getChildBirthDocActNumber()
    {
        return $this->ChildBirthDocActNumber;
    }
    /**
     * Set ChildBirthDocActNumber value
     * @param string $childBirthDocActNumber
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChildBirthDocRFType
     */
    public function setChildBirthDocActNumber($childBirthDocActNumber = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocActNumber) && !is_string($childBirthDocActNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocActNumber, true), gettype($childBirthDocActNumber)), __LINE__);
        }
        // validation for constraint: maxLength(21)
        if (!is_null($childBirthDocActNumber) && mb_strlen($childBirthDocActNumber) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 21', mb_strlen($childBirthDocActNumber)), __LINE__);
        }
        $this->ChildBirthDocActNumber = $childBirthDocActNumber;
        return $this;
    }
    /**
     * Get ChildBirthDocActDate value
     * @return string|null
     */
    public function getChildBirthDocActDate()
    {
        return $this->ChildBirthDocActDate;
    }
    /**
     * Set ChildBirthDocActDate value
     * @param string $childBirthDocActDate
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChildBirthDocRFType
     */
    public function setChildBirthDocActDate($childBirthDocActDate = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocActDate) && !is_string($childBirthDocActDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocActDate, true), gettype($childBirthDocActDate)), __LINE__);
        }
        $this->ChildBirthDocActDate = $childBirthDocActDate;
        return $this;
    }
    /**
     * Get ChildBirthDocIssued value
     * @return string|null
     */
    public function getChildBirthDocIssued()
    {
        return $this->ChildBirthDocIssued;
    }
    /**
     * Set ChildBirthDocIssued value
     * @param string $childBirthDocIssued
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChildBirthDocRFType
     */
    public function setChildBirthDocIssued($childBirthDocIssued = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocIssued) && !is_string($childBirthDocIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocIssued, true), gettype($childBirthDocIssued)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childBirthDocIssued) && mb_strlen($childBirthDocIssued) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childBirthDocIssued)), __LINE__);
        }
        $this->ChildBirthDocIssued = $childBirthDocIssued;
        return $this;
    }
}
