<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AppliedDocumentType Struct
 * Meta information extracted from the WSDL
 * - documentation: Описание прилагаемого документа
 * @subpackage Structs
 */
class AppliedDocumentType extends AbstractStructBase
{
    /**
     * The CodeDocument
     * Meta information extracted from the WSDL
     * - documentation: Код документа, генерируемый ЕПГУ
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $CodeDocument;
    /**
     * The NameDocument
     * Meta information extracted from the WSDL
     * - documentation: Имя файла загруженного документа
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $NameDocument;
    /**
     * The TypeDocument
     * Meta information extracted from the WSDL
     * - documentation: mime type контента (например: image/jpeg/pdf)
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $TypeDocument;
    /**
     * Constructor method for AppliedDocumentType
     * @uses AppliedDocumentType::setCodeDocument()
     * @uses AppliedDocumentType::setNameDocument()
     * @uses AppliedDocumentType::setTypeDocument()
     * @param string $codeDocument
     * @param string $nameDocument
     * @param string $typeDocument
     */
    public function __construct($codeDocument = null, $nameDocument = null, $typeDocument = null)
    {
        $this
            ->setCodeDocument($codeDocument)
            ->setNameDocument($nameDocument)
            ->setTypeDocument($typeDocument);
    }
    /**
     * Get CodeDocument value
     * @return string|null
     */
    public function getCodeDocument()
    {
        return $this->CodeDocument;
    }
    /**
     * Set CodeDocument value
     * @param string $codeDocument
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AppliedDocumentType
     */
    public function setCodeDocument($codeDocument = null)
    {
        // validation for constraint: string
        if (!is_null($codeDocument) && !is_string($codeDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeDocument, true), gettype($codeDocument)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($codeDocument) && mb_strlen($codeDocument) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($codeDocument)), __LINE__);
        }
        $this->CodeDocument = $codeDocument;
        return $this;
    }
    /**
     * Get NameDocument value
     * @return string|null
     */
    public function getNameDocument()
    {
        return $this->NameDocument;
    }
    /**
     * Set NameDocument value
     * @param string $nameDocument
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AppliedDocumentType
     */
    public function setNameDocument($nameDocument = null)
    {
        // validation for constraint: string
        if (!is_null($nameDocument) && !is_string($nameDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameDocument, true), gettype($nameDocument)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($nameDocument) && mb_strlen($nameDocument) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($nameDocument)), __LINE__);
        }
        $this->NameDocument = $nameDocument;
        return $this;
    }
    /**
     * Get TypeDocument value
     * @return string|null
     */
    public function getTypeDocument()
    {
        return $this->TypeDocument;
    }
    /**
     * Set TypeDocument value
     * @param string $typeDocument
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AppliedDocumentType
     */
    public function setTypeDocument($typeDocument = null)
    {
        // validation for constraint: string
        if (!is_null($typeDocument) && !is_string($typeDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDocument, true), gettype($typeDocument)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($typeDocument) && mb_strlen($typeDocument) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($typeDocument)), __LINE__);
        }
        $this->TypeDocument = $typeDocument;
        return $this;
    }
}
