<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType Struct
 * Meta information extracted from the WSDL
 * - documentation: Адрес
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The FullAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 1024
     * @var string
     */
    public $FullAddress;
    /**
     * The Index
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 6
     * @var string
     */
    public $Index;
    /**
     * The Region
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $Region;
    /**
     * The Area
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $Area;
    /**
     * The City
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $City;
    /**
     * The CityArea
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $CityArea;
    /**
     * The Place
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $Place;
    /**
     * The Street
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $Street;
    /**
     * The AdditionalArea
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $AdditionalArea;
    /**
     * The AdditionalStreet
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $AdditionalStreet;
    /**
     * The House
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $House;
    /**
     * The Building1
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $Building1;
    /**
     * The Building2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $Building2;
    /**
     * The Apartment
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $Apartment;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setFullAddress()
     * @uses AddressType::setIndex()
     * @uses AddressType::setRegion()
     * @uses AddressType::setArea()
     * @uses AddressType::setCity()
     * @uses AddressType::setCityArea()
     * @uses AddressType::setPlace()
     * @uses AddressType::setStreet()
     * @uses AddressType::setAdditionalArea()
     * @uses AddressType::setAdditionalStreet()
     * @uses AddressType::setHouse()
     * @uses AddressType::setBuilding1()
     * @uses AddressType::setBuilding2()
     * @uses AddressType::setApartment()
     * @param string $fullAddress
     * @param string $index
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $region
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $area
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $city
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $cityArea
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $place
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $street
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $additionalArea
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $additionalStreet
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $house
     * @param string $building1
     * @param string $building2
     * @param string $apartment
     */
    public function __construct($fullAddress = null, $index = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $region = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $area = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $city = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $cityArea = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $place = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $street = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $additionalArea = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $additionalStreet = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $house = null, $building1 = null, $building2 = null, $apartment = null)
    {
        $this
            ->setFullAddress($fullAddress)
            ->setIndex($index)
            ->setRegion($region)
            ->setArea($area)
            ->setCity($city)
            ->setCityArea($cityArea)
            ->setPlace($place)
            ->setStreet($street)
            ->setAdditionalArea($additionalArea)
            ->setAdditionalStreet($additionalStreet)
            ->setHouse($house)
            ->setBuilding1($building1)
            ->setBuilding2($building2)
            ->setApartment($apartment);
    }
    /**
     * Get FullAddress value
     * @return string|null
     */
    public function getFullAddress()
    {
        return $this->FullAddress;
    }
    /**
     * Set FullAddress value
     * @param string $fullAddress
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setFullAddress($fullAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fullAddress) && !is_string($fullAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullAddress, true), gettype($fullAddress)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($fullAddress) && mb_strlen($fullAddress) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($fullAddress)), __LINE__);
        }
        $this->FullAddress = $fullAddress;
        return $this;
    }
    /**
     * Get Index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param string $index
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setIndex($index = null)
    {
        // validation for constraint: string
        if (!is_null($index) && !is_string($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($index) && mb_strlen($index) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($index)), __LINE__);
        }
        $this->Index = $index;
        return $this;
    }
    /**
     * Get Region value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $region
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setRegion(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $region = null)
    {
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Area value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * Set Area value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $area
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setArea(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $area = null)
    {
        $this->Area = $area;
        return $this;
    }
    /**
     * Get City value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $city
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setCity(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get CityArea value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getCityArea()
    {
        return $this->CityArea;
    }
    /**
     * Set CityArea value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $cityArea
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setCityArea(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $cityArea = null)
    {
        $this->CityArea = $cityArea;
        return $this;
    }
    /**
     * Get Place value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $place
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setPlace(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Street value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $street
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setStreet(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $street = null)
    {
        $this->Street = $street;
        return $this;
    }
    /**
     * Get AdditionalArea value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getAdditionalArea()
    {
        return $this->AdditionalArea;
    }
    /**
     * Set AdditionalArea value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $additionalArea
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setAdditionalArea(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $additionalArea = null)
    {
        $this->AdditionalArea = $additionalArea;
        return $this;
    }
    /**
     * Get AdditionalStreet value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getAdditionalStreet()
    {
        return $this->AdditionalStreet;
    }
    /**
     * Set AdditionalStreet value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $additionalStreet
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setAdditionalStreet(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $additionalStreet = null)
    {
        $this->AdditionalStreet = $additionalStreet;
        return $this;
    }
    /**
     * Get House value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getHouse()
    {
        return $this->House;
    }
    /**
     * Set House value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $house
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setHouse(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $house = null)
    {
        $this->House = $house;
        return $this;
    }
    /**
     * Get Building1 value
     * @return string|null
     */
    public function getBuilding1()
    {
        return $this->Building1;
    }
    /**
     * Set Building1 value
     * @param string $building1
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setBuilding1($building1 = null)
    {
        // validation for constraint: string
        if (!is_null($building1) && !is_string($building1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building1, true), gettype($building1)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($building1) && mb_strlen($building1) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($building1)), __LINE__);
        }
        $this->Building1 = $building1;
        return $this;
    }
    /**
     * Get Building2 value
     * @return string|null
     */
    public function getBuilding2()
    {
        return $this->Building2;
    }
    /**
     * Set Building2 value
     * @param string $building2
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setBuilding2($building2 = null)
    {
        // validation for constraint: string
        if (!is_null($building2) && !is_string($building2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building2, true), gettype($building2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($building2) && mb_strlen($building2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($building2)), __LINE__);
        }
        $this->Building2 = $building2;
        return $this;
    }
    /**
     * Get Apartment value
     * @return string|null
     */
    public function getApartment()
    {
        return $this->Apartment;
    }
    /**
     * Set Apartment value
     * @param string $apartment
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public function setApartment($apartment = null)
    {
        // validation for constraint: string
        if (!is_null($apartment) && !is_string($apartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apartment, true), gettype($apartment)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($apartment) && mb_strlen($apartment) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($apartment)), __LINE__);
        }
        $this->Apartment = $apartment;
        return $this;
    }
}
