<?php

namespace Webservice\Service\Dto\SmevSoap;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'DataElementType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\DataElementType',
            'AddressType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\AddressType',
            'AppliedDocumentType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\AppliedDocumentType',
            'DocInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\DocInfoType',
            'PersonInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\PersonInfoType',
            'OtherRepresentativeType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\OtherRepresentativeType',
            'PersonIdentityDocInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\PersonIdentityDocInfoType',
            'ChildInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ChildInfoType',
            'ChildBirthDocRFType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ChildBirthDocRFType',
            'ChildBirthDocForeignType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ChildBirthDocForeignType',
            'EntryParamsType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\EntryParamsType',
            'AdaptationProgramType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\AdaptationProgramType',
            'MedicalReportType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\MedicalReportType',
            'MedicalReportWithoutFilesType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\MedicalReportWithoutFilesType',
            'EduOrganizationType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\EduOrganizationType',
            'EduOrganizationsType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\EduOrganizationsType',
            'BrotherSisterInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\BrotherSisterInfoType',
            'BenefitInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\BenefitInfoType',
            'BenefitInfoWithoutFilesType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\BenefitInfoWithoutFilesType',
            'ApplicationType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ApplicationType',
            'ApplicationOrderInfoRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ApplicationOrderInfoRequestType',
            'Person2InfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\Person2InfoType',
            'ApplicationAdmissionRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ApplicationAdmissionRequestType',
            'GetApplicationQueueRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\GetApplicationQueueRequestType',
            'GetApplicationQueueReasonRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\GetApplicationQueueReasonRequestType',
            'GetApplicationRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\GetApplicationRequestType',
            'GetApplicationAdmissionRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\GetApplicationAdmissionRequestType',
            'ApplicationRejectionRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ApplicationRejectionRequestType',
            'cancelRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\CancelRequestType',
            'orderIdType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\OrderIdType',
            'statusCodeType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\StatusCodeType',
            'changeOrderInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ChangeOrderInfoType',
            'ApplicationQueueResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\ApplicationQueueResponseType',
            'GetApplicationQueueReasonResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\GetApplicationQueueReasonResponseType',
            'GetApplicationResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\GetApplicationResponseType',
            'GetApplicationAdmissionResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\GetApplicationAdmissionResponseType',
            'cancelResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\CancelResponseType',
            'FormDataType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\FormDataType',
            'FormDataResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\FormDataResponseType',
            'FormRequest' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\FormRequest',
            'FormResponse' => '\\Webservice\\Service\\Dto\\SmevSoap\\Struct\\FormResponse',
        );
    }
}
