<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonInfoType Struct
 * Meta information extracted from the WSDL
 * - documentation: Сведения о заявителе
 * @subpackage Structs
 */
class PersonInfoType extends AbstractStructBase
{
    /**
     * The PersonSurname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $PersonSurname;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $PersonName;
    /**
     * The PersonMiddleName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $PersonMiddleName;
    /**
     * The PersonPhone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * @var string
     */
    public $PersonPhone;
    /**
     * The PersonEmail
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $PersonEmail;
    /**
     * The Parents
     * @var bool
     */
    public $Parents;
    /**
     * The OtherRepresentative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\Struct\OtherRepresentativeType
     */
    public $OtherRepresentative;
    /**
     * Constructor method for PersonInfoType
     * @uses PersonInfoType::setPersonSurname()
     * @uses PersonInfoType::setPersonName()
     * @uses PersonInfoType::setPersonMiddleName()
     * @uses PersonInfoType::setPersonPhone()
     * @uses PersonInfoType::setPersonEmail()
     * @uses PersonInfoType::setParents()
     * @uses PersonInfoType::setOtherRepresentative()
     * @param string $personSurname
     * @param string $personName
     * @param string $personMiddleName
     * @param string $personPhone
     * @param string $personEmail
     * @param bool $parents
     * @param \Webservice\Service\Dto\SmevSoap\Struct\OtherRepresentativeType $otherRepresentative
     */
    public function __construct($personSurname = null, $personName = null, $personMiddleName = null, $personPhone = null, $personEmail = null, $parents = null, \Webservice\Service\Dto\SmevSoap\Struct\OtherRepresentativeType $otherRepresentative = null)
    {
        $this
            ->setPersonSurname($personSurname)
            ->setPersonName($personName)
            ->setPersonMiddleName($personMiddleName)
            ->setPersonPhone($personPhone)
            ->setPersonEmail($personEmail)
            ->setParents($parents)
            ->setOtherRepresentative($otherRepresentative);
    }
    /**
     * Get PersonSurname value
     * @return string|null
     */
    public function getPersonSurname()
    {
        return $this->PersonSurname;
    }
    /**
     * Set PersonSurname value
     * @param string $personSurname
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public function setPersonSurname($personSurname = null)
    {
        // validation for constraint: string
        if (!is_null($personSurname) && !is_string($personSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personSurname, true), gettype($personSurname)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($personSurname) && mb_strlen($personSurname) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($personSurname)), __LINE__);
        }
        $this->PersonSurname = $personSurname;
        return $this;
    }
    /**
     * Get PersonName value
     * @return string|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param string $personName
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public function setPersonName($personName = null)
    {
        // validation for constraint: string
        if (!is_null($personName) && !is_string($personName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personName, true), gettype($personName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($personName) && mb_strlen($personName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($personName)), __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get PersonMiddleName value
     * @return string|null
     */
    public function getPersonMiddleName()
    {
        return $this->PersonMiddleName;
    }
    /**
     * Set PersonMiddleName value
     * @param string $personMiddleName
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public function setPersonMiddleName($personMiddleName = null)
    {
        // validation for constraint: string
        if (!is_null($personMiddleName) && !is_string($personMiddleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personMiddleName, true), gettype($personMiddleName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($personMiddleName) && mb_strlen($personMiddleName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($personMiddleName)), __LINE__);
        }
        $this->PersonMiddleName = $personMiddleName;
        return $this;
    }
    /**
     * Get PersonPhone value
     * @return string|null
     */
    public function getPersonPhone()
    {
        return $this->PersonPhone;
    }
    /**
     * Set PersonPhone value
     * @param string $personPhone
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public function setPersonPhone($personPhone = null)
    {
        // validation for constraint: string
        if (!is_null($personPhone) && !is_string($personPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personPhone, true), gettype($personPhone)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($personPhone) && mb_strlen($personPhone) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($personPhone)), __LINE__);
        }
        $this->PersonPhone = $personPhone;
        return $this;
    }
    /**
     * Get PersonEmail value
     * @return string|null
     */
    public function getPersonEmail()
    {
        return $this->PersonEmail;
    }
    /**
     * Set PersonEmail value
     * @param string $personEmail
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public function setPersonEmail($personEmail = null)
    {
        // validation for constraint: string
        if (!is_null($personEmail) && !is_string($personEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personEmail, true), gettype($personEmail)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($personEmail) && mb_strlen($personEmail) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($personEmail)), __LINE__);
        }
        $this->PersonEmail = $personEmail;
        return $this;
    }
    /**
     * Get Parents value
     * @return bool|null
     */
    public function getParents()
    {
        return $this->Parents;
    }
    /**
     * Set Parents value
     * @param bool $parents
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public function setParents($parents = null)
    {
        // validation for constraint: boolean
        if (!is_null($parents) && !is_bool($parents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($parents, true), gettype($parents)), __LINE__);
        }
        $this->Parents = $parents;
        return $this;
    }
    /**
     * Get OtherRepresentative value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\OtherRepresentativeType|null
     */
    public function getOtherRepresentative()
    {
        return $this->OtherRepresentative;
    }
    /**
     * Set OtherRepresentative value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\OtherRepresentativeType $otherRepresentative
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public function setOtherRepresentative(\Webservice\Service\Dto\SmevSoap\Struct\OtherRepresentativeType $otherRepresentative = null)
    {
        $this->OtherRepresentative = $otherRepresentative;
        return $this;
    }
}
