<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonIdentityDocInfoType Struct
 * Meta information extracted from the WSDL
 * - documentation: Паспортные данные заявителя
 * @subpackage Structs
 */
class PersonIdentityDocInfoType extends AbstractStructBase
{
    /**
     * The IdentityDocName
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $IdentityDocName;
    /**
     * The IdentityDocSeries
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $IdentityDocSeries;
    /**
     * The IdentityDocNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $IdentityDocNumber;
    /**
     * The IdentityDocIssueDate
     * @var string
     */
    public $IdentityDocIssueDate;
    /**
     * The IdentityDocIssueCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 6
     * - minOccurs: 0
     * @var string
     */
    public $IdentityDocIssueCode;
    /**
     * The IdentityDocIssued
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $IdentityDocIssued;
    /**
     * Constructor method for PersonIdentityDocInfoType
     * @uses PersonIdentityDocInfoType::setIdentityDocName()
     * @uses PersonIdentityDocInfoType::setIdentityDocSeries()
     * @uses PersonIdentityDocInfoType::setIdentityDocNumber()
     * @uses PersonIdentityDocInfoType::setIdentityDocIssueDate()
     * @uses PersonIdentityDocInfoType::setIdentityDocIssueCode()
     * @uses PersonIdentityDocInfoType::setIdentityDocIssued()
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $identityDocName
     * @param string $identityDocSeries
     * @param string $identityDocNumber
     * @param string $identityDocIssueDate
     * @param string $identityDocIssueCode
     * @param string $identityDocIssued
     */
    public function __construct(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $identityDocName = null, $identityDocSeries = null, $identityDocNumber = null, $identityDocIssueDate = null, $identityDocIssueCode = null, $identityDocIssued = null)
    {
        $this
            ->setIdentityDocName($identityDocName)
            ->setIdentityDocSeries($identityDocSeries)
            ->setIdentityDocNumber($identityDocNumber)
            ->setIdentityDocIssueDate($identityDocIssueDate)
            ->setIdentityDocIssueCode($identityDocIssueCode)
            ->setIdentityDocIssued($identityDocIssued);
    }
    /**
     * Get IdentityDocName value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getIdentityDocName()
    {
        return $this->IdentityDocName;
    }
    /**
     * Set IdentityDocName value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $identityDocName
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType
     */
    public function setIdentityDocName(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $identityDocName = null)
    {
        $this->IdentityDocName = $identityDocName;
        return $this;
    }
    /**
     * Get IdentityDocSeries value
     * @return string|null
     */
    public function getIdentityDocSeries()
    {
        return $this->IdentityDocSeries;
    }
    /**
     * Set IdentityDocSeries value
     * @param string $identityDocSeries
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType
     */
    public function setIdentityDocSeries($identityDocSeries = null)
    {
        // validation for constraint: string
        if (!is_null($identityDocSeries) && !is_string($identityDocSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityDocSeries, true), gettype($identityDocSeries)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($identityDocSeries) && mb_strlen($identityDocSeries) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($identityDocSeries)), __LINE__);
        }
        $this->IdentityDocSeries = $identityDocSeries;
        return $this;
    }
    /**
     * Get IdentityDocNumber value
     * @return string|null
     */
    public function getIdentityDocNumber()
    {
        return $this->IdentityDocNumber;
    }
    /**
     * Set IdentityDocNumber value
     * @param string $identityDocNumber
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType
     */
    public function setIdentityDocNumber($identityDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identityDocNumber) && !is_string($identityDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityDocNumber, true), gettype($identityDocNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($identityDocNumber) && mb_strlen($identityDocNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($identityDocNumber)), __LINE__);
        }
        $this->IdentityDocNumber = $identityDocNumber;
        return $this;
    }
    /**
     * Get IdentityDocIssueDate value
     * @return string|null
     */
    public function getIdentityDocIssueDate()
    {
        return $this->IdentityDocIssueDate;
    }
    /**
     * Set IdentityDocIssueDate value
     * @param string $identityDocIssueDate
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType
     */
    public function setIdentityDocIssueDate($identityDocIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($identityDocIssueDate) && !is_string($identityDocIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityDocIssueDate, true), gettype($identityDocIssueDate)), __LINE__);
        }
        $this->IdentityDocIssueDate = $identityDocIssueDate;
        return $this;
    }
    /**
     * Get IdentityDocIssueCode value
     * @return string|null
     */
    public function getIdentityDocIssueCode()
    {
        return $this->IdentityDocIssueCode;
    }
    /**
     * Set IdentityDocIssueCode value
     * @param string $identityDocIssueCode
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType
     */
    public function setIdentityDocIssueCode($identityDocIssueCode = null)
    {
        // validation for constraint: string
        if (!is_null($identityDocIssueCode) && !is_string($identityDocIssueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityDocIssueCode, true), gettype($identityDocIssueCode)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($identityDocIssueCode) && mb_strlen($identityDocIssueCode) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($identityDocIssueCode)), __LINE__);
        }
        $this->IdentityDocIssueCode = $identityDocIssueCode;
        return $this;
    }
    /**
     * Get IdentityDocIssued value
     * @return string|null
     */
    public function getIdentityDocIssued()
    {
        return $this->IdentityDocIssued;
    }
    /**
     * Set IdentityDocIssued value
     * @param string $identityDocIssued
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType
     */
    public function setIdentityDocIssued($identityDocIssued = null)
    {
        // validation for constraint: string
        if (!is_null($identityDocIssued) && !is_string($identityDocIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityDocIssued, true), gettype($identityDocIssued)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($identityDocIssued) && mb_strlen($identityDocIssued) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($identityDocIssued)), __LINE__);
        }
        $this->IdentityDocIssued = $identityDocIssued;
        return $this;
    }
}
