<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetApplicationResponseType Struct
 * Meta information extracted from the WSDL
 * - documentation: Ответ с данными заявления
 * @subpackage Structs
 */
class GetApplicationResponseType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The PersonInfo
     * @var \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public $PersonInfo;
    /**
     * The PersonIdentityDocInfo
     * @var \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType
     */
    public $PersonIdentityDocInfo;
    /**
     * The ChildInfo
     * @var \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType
     */
    public $ChildInfo;
    /**
     * The Address
     * @var \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public $Address;
    /**
     * The EntryParams
     * @var \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType
     */
    public $EntryParams;
    /**
     * The AdaptationProgram
     * @var \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType
     */
    public $AdaptationProgram;
    /**
     * The MedicalReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType
     */
    public $MedicalReport;
    /**
     * The EduOrganizations
     * @var \Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationsType
     */
    public $EduOrganizations;
    /**
     * The BrotherSisterInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType[]
     */
    public $BrotherSisterInfo;
    /**
     * The BenefitInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\Struct\BenefitInfoWithoutFilesType
     */
    public $BenefitInfo;
    /**
     * Constructor method for GetApplicationResponseType
     * @uses GetApplicationResponseType::setOrderId()
     * @uses GetApplicationResponseType::setPersonInfo()
     * @uses GetApplicationResponseType::setPersonIdentityDocInfo()
     * @uses GetApplicationResponseType::setChildInfo()
     * @uses GetApplicationResponseType::setAddress()
     * @uses GetApplicationResponseType::setEntryParams()
     * @uses GetApplicationResponseType::setAdaptationProgram()
     * @uses GetApplicationResponseType::setMedicalReport()
     * @uses GetApplicationResponseType::setEduOrganizations()
     * @uses GetApplicationResponseType::setBrotherSisterInfo()
     * @uses GetApplicationResponseType::setBenefitInfo()
     * @param int $orderId
     * @param \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType $personInfo
     * @param \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType $personIdentityDocInfo
     * @param \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType $childInfo
     * @param \Webservice\Service\Dto\SmevSoap\Struct\AddressType $address
     * @param \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType $entryParams
     * @param \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType $adaptationProgram
     * @param \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType $medicalReport
     * @param \Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationsType $eduOrganizations
     * @param \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType[] $brotherSisterInfo
     * @param \Webservice\Service\Dto\SmevSoap\Struct\BenefitInfoWithoutFilesType $benefitInfo
     */
    public function __construct($orderId = null, \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType $personInfo = null, \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType $personIdentityDocInfo = null, \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType $childInfo = null, \Webservice\Service\Dto\SmevSoap\Struct\AddressType $address = null, \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType $entryParams = null, \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType $adaptationProgram = null, \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType $medicalReport = null, \Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationsType $eduOrganizations = null, array $brotherSisterInfo = array(), \Webservice\Service\Dto\SmevSoap\Struct\BenefitInfoWithoutFilesType $benefitInfo = null)
    {
        $this
            ->setOrderId($orderId)
            ->setPersonInfo($personInfo)
            ->setPersonIdentityDocInfo($personIdentityDocInfo)
            ->setChildInfo($childInfo)
            ->setAddress($address)
            ->setEntryParams($entryParams)
            ->setAdaptationProgram($adaptationProgram)
            ->setMedicalReport($medicalReport)
            ->setEduOrganizations($eduOrganizations)
            ->setBrotherSisterInfo($brotherSisterInfo)
            ->setBenefitInfo($benefitInfo);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get PersonInfo value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType|null
     */
    public function getPersonInfo()
    {
        return $this->PersonInfo;
    }
    /**
     * Set PersonInfo value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType $personInfo
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setPersonInfo(\Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType $personInfo = null)
    {
        $this->PersonInfo = $personInfo;
        return $this;
    }
    /**
     * Get PersonIdentityDocInfo value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType|null
     */
    public function getPersonIdentityDocInfo()
    {
        return $this->PersonIdentityDocInfo;
    }
    /**
     * Set PersonIdentityDocInfo value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType $personIdentityDocInfo
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setPersonIdentityDocInfo(\Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType $personIdentityDocInfo = null)
    {
        $this->PersonIdentityDocInfo = $personIdentityDocInfo;
        return $this;
    }
    /**
     * Get ChildInfo value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType|null
     */
    public function getChildInfo()
    {
        return $this->ChildInfo;
    }
    /**
     * Set ChildInfo value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType $childInfo
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setChildInfo(\Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType $childInfo = null)
    {
        $this->ChildInfo = $childInfo;
        return $this;
    }
    /**
     * Get Address value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\AddressType $address
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setAddress(\Webservice\Service\Dto\SmevSoap\Struct\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EntryParams value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType|null
     */
    public function getEntryParams()
    {
        return $this->EntryParams;
    }
    /**
     * Set EntryParams value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType $entryParams
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setEntryParams(\Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType $entryParams = null)
    {
        $this->EntryParams = $entryParams;
        return $this;
    }
    /**
     * Get AdaptationProgram value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType|null
     */
    public function getAdaptationProgram()
    {
        return $this->AdaptationProgram;
    }
    /**
     * Set AdaptationProgram value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType $adaptationProgram
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setAdaptationProgram(\Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType $adaptationProgram = null)
    {
        $this->AdaptationProgram = $adaptationProgram;
        return $this;
    }
    /**
     * Get MedicalReport value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType|null
     */
    public function getMedicalReport()
    {
        return $this->MedicalReport;
    }
    /**
     * Set MedicalReport value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType $medicalReport
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setMedicalReport(\Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType $medicalReport = null)
    {
        $this->MedicalReport = $medicalReport;
        return $this;
    }
    /**
     * Get EduOrganizations value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationsType|null
     */
    public function getEduOrganizations()
    {
        return $this->EduOrganizations;
    }
    /**
     * Set EduOrganizations value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationsType $eduOrganizations
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setEduOrganizations(\Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationsType $eduOrganizations = null)
    {
        $this->EduOrganizations = $eduOrganizations;
        return $this;
    }
    /**
     * Get BrotherSisterInfo value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType[]|null
     */
    public function getBrotherSisterInfo()
    {
        return $this->BrotherSisterInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setBrotherSisterInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBrotherSisterInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBrotherSisterInfoForArrayConstraintsFromSetBrotherSisterInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getApplicationResponseTypeBrotherSisterInfoItem) {
            // validation for constraint: itemType
            if (!$getApplicationResponseTypeBrotherSisterInfoItem instanceof \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType) {
                $invalidValues[] = is_object($getApplicationResponseTypeBrotherSisterInfoItem) ? get_class($getApplicationResponseTypeBrotherSisterInfoItem) : sprintf('%s(%s)', gettype($getApplicationResponseTypeBrotherSisterInfoItem), var_export($getApplicationResponseTypeBrotherSisterInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BrotherSisterInfo property can only contain items of type \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BrotherSisterInfo value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType[] $brotherSisterInfo
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setBrotherSisterInfo(array $brotherSisterInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($brotherSisterInfoArrayErrorMessage = self::validateBrotherSisterInfoForArrayConstraintsFromSetBrotherSisterInfo($brotherSisterInfo))) {
            throw new \InvalidArgumentException($brotherSisterInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($brotherSisterInfo) && count($brotherSisterInfo) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($brotherSisterInfo)), __LINE__);
        }
        $this->BrotherSisterInfo = $brotherSisterInfo;
        return $this;
    }
    /**
     * Add item to BrotherSisterInfo value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType $item
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function addToBrotherSisterInfo(\Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType) {
            throw new \InvalidArgumentException(sprintf('The BrotherSisterInfo property can only contain items of type \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->BrotherSisterInfo) && count($this->BrotherSisterInfo) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->BrotherSisterInfo)), __LINE__);
        }
        $this->BrotherSisterInfo[] = $item;
        return $this;
    }
    /**
     * Get BenefitInfo value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\BenefitInfoWithoutFilesType|null
     */
    public function getBenefitInfo()
    {
        return $this->BenefitInfo;
    }
    /**
     * Set BenefitInfo value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\BenefitInfoWithoutFilesType $benefitInfo
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationResponseType
     */
    public function setBenefitInfo(\Webservice\Service\Dto\SmevSoap\Struct\BenefitInfoWithoutFilesType $benefitInfo = null)
    {
        $this->BenefitInfo = $benefitInfo;
        return $this;
    }
}
