<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetApplicationAdmissionResponseType Struct
 * Meta information extracted from the WSDL
 * - documentation: Ответ с данными для подачи заявления на приём
 * @subpackage Structs
 */
class GetApplicationAdmissionResponseType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The PersonInfo
     * @var \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType
     */
    public $PersonInfo;
    /**
     * The PersonIdentityDocInfo
     * @var \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType
     */
    public $PersonIdentityDocInfo;
    /**
     * The ChildInfo
     * @var \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType
     */
    public $ChildInfo;
    /**
     * The Address
     * @var \Webservice\Service\Dto\SmevSoap\Struct\AddressType
     */
    public $Address;
    /**
     * The EntryParams
     * @var \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType
     */
    public $EntryParams;
    /**
     * The AdaptationProgram
     * @var \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType
     */
    public $AdaptationProgram;
    /**
     * The MedicalReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType
     */
    public $MedicalReport;
    /**
     * The EduOrganizationCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $EduOrganizationCode;
    /**
     * Constructor method for GetApplicationAdmissionResponseType
     * @uses GetApplicationAdmissionResponseType::setOrderId()
     * @uses GetApplicationAdmissionResponseType::setPersonInfo()
     * @uses GetApplicationAdmissionResponseType::setPersonIdentityDocInfo()
     * @uses GetApplicationAdmissionResponseType::setChildInfo()
     * @uses GetApplicationAdmissionResponseType::setAddress()
     * @uses GetApplicationAdmissionResponseType::setEntryParams()
     * @uses GetApplicationAdmissionResponseType::setAdaptationProgram()
     * @uses GetApplicationAdmissionResponseType::setMedicalReport()
     * @uses GetApplicationAdmissionResponseType::setEduOrganizationCode()
     * @param int $orderId
     * @param \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType $personInfo
     * @param \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType $personIdentityDocInfo
     * @param \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType $childInfo
     * @param \Webservice\Service\Dto\SmevSoap\Struct\AddressType $address
     * @param \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType $entryParams
     * @param \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType $adaptationProgram
     * @param \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType $medicalReport
     * @param string $eduOrganizationCode
     */
    public function __construct($orderId = null, \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType $personInfo = null, \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType $personIdentityDocInfo = null, \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType $childInfo = null, \Webservice\Service\Dto\SmevSoap\Struct\AddressType $address = null, \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType $entryParams = null, \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType $adaptationProgram = null, \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType $medicalReport = null, $eduOrganizationCode = null)
    {
        $this
            ->setOrderId($orderId)
            ->setPersonInfo($personInfo)
            ->setPersonIdentityDocInfo($personIdentityDocInfo)
            ->setChildInfo($childInfo)
            ->setAddress($address)
            ->setEntryParams($entryParams)
            ->setAdaptationProgram($adaptationProgram)
            ->setMedicalReport($medicalReport)
            ->setEduOrganizationCode($eduOrganizationCode);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get PersonInfo value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType|null
     */
    public function getPersonInfo()
    {
        return $this->PersonInfo;
    }
    /**
     * Set PersonInfo value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType $personInfo
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setPersonInfo(\Webservice\Service\Dto\SmevSoap\Struct\PersonInfoType $personInfo = null)
    {
        $this->PersonInfo = $personInfo;
        return $this;
    }
    /**
     * Get PersonIdentityDocInfo value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType|null
     */
    public function getPersonIdentityDocInfo()
    {
        return $this->PersonIdentityDocInfo;
    }
    /**
     * Set PersonIdentityDocInfo value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType $personIdentityDocInfo
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setPersonIdentityDocInfo(\Webservice\Service\Dto\SmevSoap\Struct\PersonIdentityDocInfoType $personIdentityDocInfo = null)
    {
        $this->PersonIdentityDocInfo = $personIdentityDocInfo;
        return $this;
    }
    /**
     * Get ChildInfo value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType|null
     */
    public function getChildInfo()
    {
        return $this->ChildInfo;
    }
    /**
     * Set ChildInfo value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType $childInfo
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setChildInfo(\Webservice\Service\Dto\SmevSoap\Struct\ChildInfoType $childInfo = null)
    {
        $this->ChildInfo = $childInfo;
        return $this;
    }
    /**
     * Get Address value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\AddressType $address
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setAddress(\Webservice\Service\Dto\SmevSoap\Struct\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EntryParams value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType|null
     */
    public function getEntryParams()
    {
        return $this->EntryParams;
    }
    /**
     * Set EntryParams value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType $entryParams
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setEntryParams(\Webservice\Service\Dto\SmevSoap\Struct\EntryParamsType $entryParams = null)
    {
        $this->EntryParams = $entryParams;
        return $this;
    }
    /**
     * Get AdaptationProgram value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType|null
     */
    public function getAdaptationProgram()
    {
        return $this->AdaptationProgram;
    }
    /**
     * Set AdaptationProgram value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType $adaptationProgram
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setAdaptationProgram(\Webservice\Service\Dto\SmevSoap\Struct\AdaptationProgramType $adaptationProgram = null)
    {
        $this->AdaptationProgram = $adaptationProgram;
        return $this;
    }
    /**
     * Get MedicalReport value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType|null
     */
    public function getMedicalReport()
    {
        return $this->MedicalReport;
    }
    /**
     * Set MedicalReport value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType $medicalReport
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setMedicalReport(\Webservice\Service\Dto\SmevSoap\Struct\MedicalReportWithoutFilesType $medicalReport = null)
    {
        $this->MedicalReport = $medicalReport;
        return $this;
    }
    /**
     * Get EduOrganizationCode value
     * @return string|null
     */
    public function getEduOrganizationCode()
    {
        return $this->EduOrganizationCode;
    }
    /**
     * Set EduOrganizationCode value
     * @param string $eduOrganizationCode
     * @return \Webservice\Service\Dto\SmevSoap\Struct\GetApplicationAdmissionResponseType
     */
    public function setEduOrganizationCode($eduOrganizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($eduOrganizationCode) && !is_string($eduOrganizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eduOrganizationCode, true), gettype($eduOrganizationCode)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($eduOrganizationCode) && mb_strlen($eduOrganizationCode) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($eduOrganizationCode)), __LINE__);
        }
        $this->EduOrganizationCode = $eduOrganizationCode;
        return $this;
    }
}
