<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EduOrganizationType Struct
 * Meta information extracted from the WSDL
 * - documentation: Выбранный детский сад
 * - base: xsd:string
 * - maxLength: 256
 * @subpackage Structs
 */
class EduOrganizationType extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - use: required
     * @var string
     */
    public $code;
    /**
     * The PriorityNumber
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PriorityNumber;
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $_;
    /**
     * Constructor method for EduOrganizationType
     * @uses EduOrganizationType::setCode()
     * @uses EduOrganizationType::setPriorityNumber()
     * @uses EduOrganizationType::set_()
     * @param string $code
     * @param string $priorityNumber
     * @param string $_
     */
    public function __construct($code = null, $priorityNumber = null, $_ = null)
    {
        $this
            ->setCode($code)
            ->setPriorityNumber($priorityNumber)
            ->set_($_);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($code) && mb_strlen($code) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get PriorityNumber value
     * @return string
     */
    public function getPriorityNumber()
    {
        return $this->PriorityNumber;
    }
    /**
     * Set PriorityNumber value
     * @param string $priorityNumber
     * @return \Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationType
     */
    public function setPriorityNumber($priorityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($priorityNumber) && !is_string($priorityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priorityNumber, true), gettype($priorityNumber)), __LINE__);
        }
        $this->PriorityNumber = $priorityNumber;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Webservice\Service\Dto\SmevSoap\Struct\EduOrganizationType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($_) && mb_strlen($_) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
