<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for changeOrderInfoType Struct
 * Meta information extracted from the WSDL
 * - documentation: Информация для изменения статуса заявления для направления в ЛК ЕПГУ
 * @subpackage Structs
 */
class ChangeOrderInfoType extends AbstractStructBase
{
    /**
     * The orderId
     * @var \Webservice\Service\Dto\SmevSoap\Struct\OrderIdType
     */
    public $orderId;
    /**
     * The statusCode
     * @var \Webservice\Service\Dto\SmevSoap\Struct\StatusCodeType
     */
    public $statusCode;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The cancelAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $cancelAllowed;
    /**
     * Constructor method for changeOrderInfoType
     * @uses ChangeOrderInfoType::setOrderId()
     * @uses ChangeOrderInfoType::setStatusCode()
     * @uses ChangeOrderInfoType::setComment()
     * @uses ChangeOrderInfoType::setCancelAllowed()
     * @param \Webservice\Service\Dto\SmevSoap\Struct\OrderIdType $orderId
     * @param \Webservice\Service\Dto\SmevSoap\Struct\StatusCodeType $statusCode
     * @param string $comment
     * @param bool $cancelAllowed
     */
    public function __construct(\Webservice\Service\Dto\SmevSoap\Struct\OrderIdType $orderId = null, \Webservice\Service\Dto\SmevSoap\Struct\StatusCodeType $statusCode = null, $comment = null, $cancelAllowed = null)
    {
        $this
            ->setOrderId($orderId)
            ->setStatusCode($statusCode)
            ->setComment($comment)
            ->setCancelAllowed($cancelAllowed);
    }
    /**
     * Get orderId value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\OrderIdType|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\OrderIdType $orderId
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChangeOrderInfoType
     */
    public function setOrderId(\Webservice\Service\Dto\SmevSoap\Struct\OrderIdType $orderId = null)
    {
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get statusCode value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\StatusCodeType|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\StatusCodeType $statusCode
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChangeOrderInfoType
     */
    public function setStatusCode(\Webservice\Service\Dto\SmevSoap\Struct\StatusCodeType $statusCode = null)
    {
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChangeOrderInfoType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($comment) && mb_strlen($comment) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get cancelAllowed value
     * @return bool|null
     */
    public function getCancelAllowed()
    {
        return $this->cancelAllowed;
    }
    /**
     * Set cancelAllowed value
     * @param bool $cancelAllowed
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ChangeOrderInfoType
     */
    public function setCancelAllowed($cancelAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelAllowed) && !is_bool($cancelAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelAllowed, true), gettype($cancelAllowed)), __LINE__);
        }
        $this->cancelAllowed = $cancelAllowed;
        return $this;
    }
}
