<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelRequestType Struct
 * Meta information extracted from the WSDL
 * - documentation: Запрос на отмену заявления для направления
 * @subpackage Structs
 */
class CancelRequestType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * Constructor method for cancelRequestType
     * @uses CancelRequestType::setOrderId()
     * @uses CancelRequestType::setReason()
     * @param int $orderId
     * @param string $reason
     */
    public function __construct($orderId = null, $reason = null)
    {
        $this
            ->setOrderId($orderId)
            ->setReason($reason);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\Struct\CancelRequestType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \Webservice\Service\Dto\SmevSoap\Struct\CancelRequestType
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($reason) && mb_strlen($reason) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
}
