<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrotherSisterInfoType Struct
 * Meta information extracted from the WSDL
 * - documentation: Сведения об обучении братьев или сестер ребенка в выбранных организациях
 * @subpackage Structs
 */
class BrotherSisterInfoType extends AbstractStructBase
{
    /**
     * The ChildSurname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $ChildSurname;
    /**
     * The ChildName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $ChildName;
    /**
     * The ChildMiddleName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $ChildMiddleName;
    /**
     * The EduOrganization
     * @var \Webservice\Service\Dto\SmevSoap\Struct\DataElementType
     */
    public $EduOrganization;
    /**
     * Constructor method for BrotherSisterInfoType
     * @uses BrotherSisterInfoType::setChildSurname()
     * @uses BrotherSisterInfoType::setChildName()
     * @uses BrotherSisterInfoType::setChildMiddleName()
     * @uses BrotherSisterInfoType::setEduOrganization()
     * @param string $childSurname
     * @param string $childName
     * @param string $childMiddleName
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $eduOrganization
     */
    public function __construct($childSurname = null, $childName = null, $childMiddleName = null, \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $eduOrganization = null)
    {
        $this
            ->setChildSurname($childSurname)
            ->setChildName($childName)
            ->setChildMiddleName($childMiddleName)
            ->setEduOrganization($eduOrganization);
    }
    /**
     * Get ChildSurname value
     * @return string|null
     */
    public function getChildSurname()
    {
        return $this->ChildSurname;
    }
    /**
     * Set ChildSurname value
     * @param string $childSurname
     * @return \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType
     */
    public function setChildSurname($childSurname = null)
    {
        // validation for constraint: string
        if (!is_null($childSurname) && !is_string($childSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childSurname, true), gettype($childSurname)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childSurname) && mb_strlen($childSurname) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childSurname)), __LINE__);
        }
        $this->ChildSurname = $childSurname;
        return $this;
    }
    /**
     * Get ChildName value
     * @return string|null
     */
    public function getChildName()
    {
        return $this->ChildName;
    }
    /**
     * Set ChildName value
     * @param string $childName
     * @return \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType
     */
    public function setChildName($childName = null)
    {
        // validation for constraint: string
        if (!is_null($childName) && !is_string($childName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childName, true), gettype($childName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childName) && mb_strlen($childName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childName)), __LINE__);
        }
        $this->ChildName = $childName;
        return $this;
    }
    /**
     * Get ChildMiddleName value
     * @return string|null
     */
    public function getChildMiddleName()
    {
        return $this->ChildMiddleName;
    }
    /**
     * Set ChildMiddleName value
     * @param string $childMiddleName
     * @return \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType
     */
    public function setChildMiddleName($childMiddleName = null)
    {
        // validation for constraint: string
        if (!is_null($childMiddleName) && !is_string($childMiddleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childMiddleName, true), gettype($childMiddleName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childMiddleName) && mb_strlen($childMiddleName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childMiddleName)), __LINE__);
        }
        $this->ChildMiddleName = $childMiddleName;
        return $this;
    }
    /**
     * Get EduOrganization value
     * @return \Webservice\Service\Dto\SmevSoap\Struct\DataElementType|null
     */
    public function getEduOrganization()
    {
        return $this->EduOrganization;
    }
    /**
     * Set EduOrganization value
     * @param \Webservice\Service\Dto\SmevSoap\Struct\DataElementType $eduOrganization
     * @return \Webservice\Service\Dto\SmevSoap\Struct\BrotherSisterInfoType
     */
    public function setEduOrganization(\Webservice\Service\Dto\SmevSoap\Struct\DataElementType $eduOrganization = null)
    {
        $this->EduOrganization = $eduOrganization;
        return $this;
    }
}
