<?php

namespace Webservice\Service\Dto\SmevSoap\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationRejectionRequestType Struct
 * Meta information extracted from the WSDL
 * - documentation: Отказ от предложенной дошкольной организации
 * @subpackage Structs
 */
class ApplicationRejectionRequestType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for ApplicationRejectionRequestType
     * @uses ApplicationRejectionRequestType::setOrderId()
     * @uses ApplicationRejectionRequestType::setComment()
     * @param int $orderId
     * @param string $comment
     */
    public function __construct($orderId = null, $comment = null)
    {
        $this
            ->setOrderId($orderId)
            ->setComment($comment);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ApplicationRejectionRequestType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \Webservice\Service\Dto\SmevSoap\Struct\ApplicationRejectionRequestType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($comment) && mb_strlen($comment) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
