<?php

namespace Webservice\Service\Dto\SmevSoap\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Form Service
 * @subpackage Services
 */
class Form extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FormData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Webservice\Service\Dto\SmevSoap\Struct\FormRequest $parameters
     * @return \Webservice\Service\Dto\SmevSoap\Struct\FormResponse|bool
     */
    public function FormData(\Webservice\Service\Dto\SmevSoap\Struct\FormRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FormData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Webservice\Service\Dto\SmevSoap\Struct\FormResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
