<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherRepresentativeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Сведения о документе, подтверждающем полномочия заявителя
 * @subpackage Structs
 */
class OtherRepresentativeType extends AbstractStructBase
{
    /**
     * The OtherRepresentativeDocName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $OtherRepresentativeDocName;
    /**
     * The OtherRepresentativeDocSeries
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $OtherRepresentativeDocSeries;
    /**
     * The OtherRepresentativeDocNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $OtherRepresentativeDocNumber;
    /**
     * The OtherRepresentativeDocDate
     * @var string
     */
    public $OtherRepresentativeDocDate;
    /**
     * The OtherRepresentativeDocIssued
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $OtherRepresentativeDocIssued;
    /**
     * Constructor method for OtherRepresentativeType
     * @uses OtherRepresentativeType::setOtherRepresentativeDocName()
     * @uses OtherRepresentativeType::setOtherRepresentativeDocSeries()
     * @uses OtherRepresentativeType::setOtherRepresentativeDocNumber()
     * @uses OtherRepresentativeType::setOtherRepresentativeDocDate()
     * @uses OtherRepresentativeType::setOtherRepresentativeDocIssued()
     * @param string $otherRepresentativeDocName
     * @param string $otherRepresentativeDocSeries
     * @param string $otherRepresentativeDocNumber
     * @param string $otherRepresentativeDocDate
     * @param string $otherRepresentativeDocIssued
     */
    public function __construct($otherRepresentativeDocName = null, $otherRepresentativeDocSeries = null, $otherRepresentativeDocNumber = null, $otherRepresentativeDocDate = null, $otherRepresentativeDocIssued = null)
    {
        $this
            ->setOtherRepresentativeDocName($otherRepresentativeDocName)
            ->setOtherRepresentativeDocSeries($otherRepresentativeDocSeries)
            ->setOtherRepresentativeDocNumber($otherRepresentativeDocNumber)
            ->setOtherRepresentativeDocDate($otherRepresentativeDocDate)
            ->setOtherRepresentativeDocIssued($otherRepresentativeDocIssued);
    }
    /**
     * Get OtherRepresentativeDocName value
     * @return string|null
     */
    public function getOtherRepresentativeDocName()
    {
        return $this->OtherRepresentativeDocName;
    }
    /**
     * Set OtherRepresentativeDocName value
     * @param string $otherRepresentativeDocName
     * @return \Webservice\Service\Dto\SmevSoap\StructType\OtherRepresentativeType
     */
    public function setOtherRepresentativeDocName($otherRepresentativeDocName = null)
    {
        // validation for constraint: string
        if (!is_null($otherRepresentativeDocName) && !is_string($otherRepresentativeDocName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRepresentativeDocName, true), gettype($otherRepresentativeDocName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($otherRepresentativeDocName) && mb_strlen($otherRepresentativeDocName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($otherRepresentativeDocName)), __LINE__);
        }
        $this->OtherRepresentativeDocName = $otherRepresentativeDocName;
        return $this;
    }
    /**
     * Get OtherRepresentativeDocSeries value
     * @return string|null
     */
    public function getOtherRepresentativeDocSeries()
    {
        return $this->OtherRepresentativeDocSeries;
    }
    /**
     * Set OtherRepresentativeDocSeries value
     * @param string $otherRepresentativeDocSeries
     * @return \Webservice\Service\Dto\SmevSoap\StructType\OtherRepresentativeType
     */
    public function setOtherRepresentativeDocSeries($otherRepresentativeDocSeries = null)
    {
        // validation for constraint: string
        if (!is_null($otherRepresentativeDocSeries) && !is_string($otherRepresentativeDocSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRepresentativeDocSeries, true), gettype($otherRepresentativeDocSeries)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($otherRepresentativeDocSeries) && mb_strlen($otherRepresentativeDocSeries) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($otherRepresentativeDocSeries)), __LINE__);
        }
        $this->OtherRepresentativeDocSeries = $otherRepresentativeDocSeries;
        return $this;
    }
    /**
     * Get OtherRepresentativeDocNumber value
     * @return string|null
     */
    public function getOtherRepresentativeDocNumber()
    {
        return $this->OtherRepresentativeDocNumber;
    }
    /**
     * Set OtherRepresentativeDocNumber value
     * @param string $otherRepresentativeDocNumber
     * @return \Webservice\Service\Dto\SmevSoap\StructType\OtherRepresentativeType
     */
    public function setOtherRepresentativeDocNumber($otherRepresentativeDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($otherRepresentativeDocNumber) && !is_string($otherRepresentativeDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRepresentativeDocNumber, true), gettype($otherRepresentativeDocNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($otherRepresentativeDocNumber) && mb_strlen($otherRepresentativeDocNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($otherRepresentativeDocNumber)), __LINE__);
        }
        $this->OtherRepresentativeDocNumber = $otherRepresentativeDocNumber;
        return $this;
    }
    /**
     * Get OtherRepresentativeDocDate value
     * @return string|null
     */
    public function getOtherRepresentativeDocDate()
    {
        return $this->OtherRepresentativeDocDate;
    }
    /**
     * Set OtherRepresentativeDocDate value
     * @param string $otherRepresentativeDocDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\OtherRepresentativeType
     */
    public function setOtherRepresentativeDocDate($otherRepresentativeDocDate = null)
    {
        // validation for constraint: string
        if (!is_null($otherRepresentativeDocDate) && !is_string($otherRepresentativeDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRepresentativeDocDate, true), gettype($otherRepresentativeDocDate)), __LINE__);
        }
        $this->OtherRepresentativeDocDate = $otherRepresentativeDocDate;
        return $this;
    }
    /**
     * Get OtherRepresentativeDocIssued value
     * @return string|null
     */
    public function getOtherRepresentativeDocIssued()
    {
        return $this->OtherRepresentativeDocIssued;
    }
    /**
     * Set OtherRepresentativeDocIssued value
     * @param string $otherRepresentativeDocIssued
     * @return \Webservice\Service\Dto\SmevSoap\StructType\OtherRepresentativeType
     */
    public function setOtherRepresentativeDocIssued($otherRepresentativeDocIssued = null)
    {
        // validation for constraint: string
        if (!is_null($otherRepresentativeDocIssued) && !is_string($otherRepresentativeDocIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRepresentativeDocIssued, true), gettype($otherRepresentativeDocIssued)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($otherRepresentativeDocIssued) && mb_strlen($otherRepresentativeDocIssued) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($otherRepresentativeDocIssued)), __LINE__);
        }
        $this->OtherRepresentativeDocIssued = $otherRepresentativeDocIssued;
        return $this;
    }
}
