<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Заявление для направления в дошкольную организацию или заявление на получение информации об этапах и результатах оказания
 * услуги зачисления в дошкольную организацию или заявление на приём в дошкольную организацию или запрос получения информации о
 * последовательности предоставления мест или запрос получения информации об основаниях изменения последовательности предоставления
 * мест или запрос получения данных заявления для редактирования или запрос получения данных для подачи заявления на приём или отказ от
 * предложенной дошкольной организации или запрос на отмену заявления для направления в дошкольную организацию
 * @subpackage Structs
 */
class FormDataType extends AbstractStructBase
{
    /**
     * The oktmo
     * Meta information extracted from the WSDL
     * - base: xsd:normalizedString
     * - maxLength: 11
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $oktmo;
    /**
     * The ApplicationRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public $ApplicationRequest;
    /**
     * The ApplicationOrderInfoRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType
     */
    public $ApplicationOrderInfoRequest;
    /**
     * The ApplicationAdmissionRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public $ApplicationAdmissionRequest;
    /**
     * The GetApplicationQueueRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueRequestType
     */
    public $GetApplicationQueueRequest;
    /**
     * The GetApplicationQueueReasonRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueReasonRequestType
     */
    public $GetApplicationQueueReasonRequest;
    /**
     * The GetApplicationRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationRequestType
     */
    public $GetApplicationRequest;
    /**
     * The GetApplicationAdmissionRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationAdmissionRequestType
     */
    public $GetApplicationAdmissionRequest;
    /**
     * The ApplicationRejectionRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ApplicationRejectionRequestType
     */
    public $ApplicationRejectionRequest;
    /**
     * The cancelRequest
     * Meta information extracted from the WSDL
     * - choice: ApplicationRequest | ApplicationOrderInfoRequest | ApplicationAdmissionRequest | GetApplicationQueueRequest | GetApplicationQueueReasonRequest | GetApplicationRequest | GetApplicationAdmissionRequest | ApplicationRejectionRequest |
     * cancelRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\CancelRequestType
     */
    public $cancelRequest;
    /**
     * Constructor method for FormDataType
     * @uses FormDataType::setOktmo()
     * @uses FormDataType::setApplicationRequest()
     * @uses FormDataType::setApplicationOrderInfoRequest()
     * @uses FormDataType::setApplicationAdmissionRequest()
     * @uses FormDataType::setGetApplicationQueueRequest()
     * @uses FormDataType::setGetApplicationQueueReasonRequest()
     * @uses FormDataType::setGetApplicationRequest()
     * @uses FormDataType::setGetApplicationAdmissionRequest()
     * @uses FormDataType::setApplicationRejectionRequest()
     * @uses FormDataType::setCancelRequest()
     * @param string $oktmo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType $applicationRequest
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType $applicationOrderInfoRequest
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType $applicationAdmissionRequest
     * @param \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueRequestType $getApplicationQueueRequest
     * @param \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueReasonRequestType $getApplicationQueueReasonRequest
     * @param \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationRequestType $getApplicationRequest
     * @param \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationAdmissionRequestType $getApplicationAdmissionRequest
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ApplicationRejectionRequestType $applicationRejectionRequest
     * @param \Webservice\Service\Dto\SmevSoap\StructType\CancelRequestType $cancelRequest
     */
    public function __construct($oktmo = null, \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType $applicationRequest = null, \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType $applicationOrderInfoRequest = null, \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType $applicationAdmissionRequest = null, \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueRequestType $getApplicationQueueRequest = null, \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueReasonRequestType $getApplicationQueueReasonRequest = null, \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationRequestType $getApplicationRequest = null, \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationAdmissionRequestType $getApplicationAdmissionRequest = null, \Webservice\Service\Dto\SmevSoap\StructType\ApplicationRejectionRequestType $applicationRejectionRequest = null, \Webservice\Service\Dto\SmevSoap\StructType\CancelRequestType $cancelRequest = null)
    {
        $this
            ->setOktmo($oktmo)
            ->setApplicationRequest($applicationRequest)
            ->setApplicationOrderInfoRequest($applicationOrderInfoRequest)
            ->setApplicationAdmissionRequest($applicationAdmissionRequest)
            ->setGetApplicationQueueRequest($getApplicationQueueRequest)
            ->setGetApplicationQueueReasonRequest($getApplicationQueueReasonRequest)
            ->setGetApplicationRequest($getApplicationRequest)
            ->setGetApplicationAdmissionRequest($getApplicationAdmissionRequest)
            ->setApplicationRejectionRequest($applicationRejectionRequest)
            ->setCancelRequest($cancelRequest);
    }
    /**
     * Get oktmo value
     * @return string
     */
    public function getOktmo()
    {
        return $this->oktmo;
    }
    /**
     * Set oktmo value
     * @param string $oktmo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setOktmo($oktmo = null)
    {
        // validation for constraint: string
        if (!is_null($oktmo) && !is_string($oktmo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oktmo, true), gettype($oktmo)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($oktmo) && mb_strlen($oktmo) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($oktmo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($oktmo) && mb_strlen($oktmo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($oktmo)), __LINE__);
        }
        $this->oktmo = $oktmo;
        return $this;
    }
    /**
     * Get ApplicationRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType|null
     */
    public function getApplicationRequest()
    {
        return isset($this->ApplicationRequest) ? $this->ApplicationRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setApplicationRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicationRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateApplicationRequestForChoiceConstraintsFromSetApplicationRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationOrderInfoRequest',
            'ApplicationAdmissionRequest',
            'GetApplicationQueueRequest',
            'GetApplicationQueueReasonRequest',
            'GetApplicationRequest',
            'GetApplicationAdmissionRequest',
            'ApplicationRejectionRequest',
            'cancelRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ApplicationRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ApplicationRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ApplicationRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType $applicationRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setApplicationRequest(\Webservice\Service\Dto\SmevSoap\StructType\ApplicationType $applicationRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($applicationRequestChoiceErrorMessage = self::validateApplicationRequestForChoiceConstraintsFromSetApplicationRequest($applicationRequest))) {
            throw new \InvalidArgumentException($applicationRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($applicationRequest) || (is_array($applicationRequest) && empty($applicationRequest))) {
            unset($this->ApplicationRequest);
        } else {
            $this->ApplicationRequest = $applicationRequest;
        }
        return $this;
    }
    /**
     * Get ApplicationOrderInfoRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType|null
     */
    public function getApplicationOrderInfoRequest()
    {
        return isset($this->ApplicationOrderInfoRequest) ? $this->ApplicationOrderInfoRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setApplicationOrderInfoRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicationOrderInfoRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateApplicationOrderInfoRequestForChoiceConstraintsFromSetApplicationOrderInfoRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationRequest',
            'ApplicationAdmissionRequest',
            'GetApplicationQueueRequest',
            'GetApplicationQueueReasonRequest',
            'GetApplicationRequest',
            'GetApplicationAdmissionRequest',
            'ApplicationRejectionRequest',
            'cancelRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ApplicationOrderInfoRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ApplicationOrderInfoRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ApplicationOrderInfoRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType $applicationOrderInfoRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setApplicationOrderInfoRequest(\Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType $applicationOrderInfoRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($applicationOrderInfoRequestChoiceErrorMessage = self::validateApplicationOrderInfoRequestForChoiceConstraintsFromSetApplicationOrderInfoRequest($applicationOrderInfoRequest))) {
            throw new \InvalidArgumentException($applicationOrderInfoRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($applicationOrderInfoRequest) || (is_array($applicationOrderInfoRequest) && empty($applicationOrderInfoRequest))) {
            unset($this->ApplicationOrderInfoRequest);
        } else {
            $this->ApplicationOrderInfoRequest = $applicationOrderInfoRequest;
        }
        return $this;
    }
    /**
     * Get ApplicationAdmissionRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType|null
     */
    public function getApplicationAdmissionRequest()
    {
        return isset($this->ApplicationAdmissionRequest) ? $this->ApplicationAdmissionRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setApplicationAdmissionRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicationAdmissionRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateApplicationAdmissionRequestForChoiceConstraintsFromSetApplicationAdmissionRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationRequest',
            'ApplicationOrderInfoRequest',
            'GetApplicationQueueRequest',
            'GetApplicationQueueReasonRequest',
            'GetApplicationRequest',
            'GetApplicationAdmissionRequest',
            'ApplicationRejectionRequest',
            'cancelRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ApplicationAdmissionRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ApplicationAdmissionRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ApplicationAdmissionRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType $applicationAdmissionRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setApplicationAdmissionRequest(\Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType $applicationAdmissionRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($applicationAdmissionRequestChoiceErrorMessage = self::validateApplicationAdmissionRequestForChoiceConstraintsFromSetApplicationAdmissionRequest($applicationAdmissionRequest))) {
            throw new \InvalidArgumentException($applicationAdmissionRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($applicationAdmissionRequest) || (is_array($applicationAdmissionRequest) && empty($applicationAdmissionRequest))) {
            unset($this->ApplicationAdmissionRequest);
        } else {
            $this->ApplicationAdmissionRequest = $applicationAdmissionRequest;
        }
        return $this;
    }
    /**
     * Get GetApplicationQueueRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueRequestType|null
     */
    public function getGetApplicationQueueRequest()
    {
        return isset($this->GetApplicationQueueRequest) ? $this->GetApplicationQueueRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGetApplicationQueueRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetApplicationQueueRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGetApplicationQueueRequestForChoiceConstraintsFromSetGetApplicationQueueRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationRequest',
            'ApplicationOrderInfoRequest',
            'ApplicationAdmissionRequest',
            'GetApplicationQueueReasonRequest',
            'GetApplicationRequest',
            'GetApplicationAdmissionRequest',
            'ApplicationRejectionRequest',
            'cancelRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GetApplicationQueueRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: GetApplicationQueueRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GetApplicationQueueRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueRequestType $getApplicationQueueRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setGetApplicationQueueRequest(\Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueRequestType $getApplicationQueueRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($getApplicationQueueRequestChoiceErrorMessage = self::validateGetApplicationQueueRequestForChoiceConstraintsFromSetGetApplicationQueueRequest($getApplicationQueueRequest))) {
            throw new \InvalidArgumentException($getApplicationQueueRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($getApplicationQueueRequest) || (is_array($getApplicationQueueRequest) && empty($getApplicationQueueRequest))) {
            unset($this->GetApplicationQueueRequest);
        } else {
            $this->GetApplicationQueueRequest = $getApplicationQueueRequest;
        }
        return $this;
    }
    /**
     * Get GetApplicationQueueReasonRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueReasonRequestType|null
     */
    public function getGetApplicationQueueReasonRequest()
    {
        return isset($this->GetApplicationQueueReasonRequest) ? $this->GetApplicationQueueReasonRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGetApplicationQueueReasonRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetApplicationQueueReasonRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGetApplicationQueueReasonRequestForChoiceConstraintsFromSetGetApplicationQueueReasonRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationRequest',
            'ApplicationOrderInfoRequest',
            'ApplicationAdmissionRequest',
            'GetApplicationQueueRequest',
            'GetApplicationRequest',
            'GetApplicationAdmissionRequest',
            'ApplicationRejectionRequest',
            'cancelRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GetApplicationQueueReasonRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: GetApplicationQueueReasonRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GetApplicationQueueReasonRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueReasonRequestType $getApplicationQueueReasonRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setGetApplicationQueueReasonRequest(\Webservice\Service\Dto\SmevSoap\StructType\GetApplicationQueueReasonRequestType $getApplicationQueueReasonRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($getApplicationQueueReasonRequestChoiceErrorMessage = self::validateGetApplicationQueueReasonRequestForChoiceConstraintsFromSetGetApplicationQueueReasonRequest($getApplicationQueueReasonRequest))) {
            throw new \InvalidArgumentException($getApplicationQueueReasonRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($getApplicationQueueReasonRequest) || (is_array($getApplicationQueueReasonRequest) && empty($getApplicationQueueReasonRequest))) {
            unset($this->GetApplicationQueueReasonRequest);
        } else {
            $this->GetApplicationQueueReasonRequest = $getApplicationQueueReasonRequest;
        }
        return $this;
    }
    /**
     * Get GetApplicationRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationRequestType|null
     */
    public function getGetApplicationRequest()
    {
        return isset($this->GetApplicationRequest) ? $this->GetApplicationRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGetApplicationRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetApplicationRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGetApplicationRequestForChoiceConstraintsFromSetGetApplicationRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationRequest',
            'ApplicationOrderInfoRequest',
            'ApplicationAdmissionRequest',
            'GetApplicationQueueRequest',
            'GetApplicationQueueReasonRequest',
            'GetApplicationAdmissionRequest',
            'ApplicationRejectionRequest',
            'cancelRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GetApplicationRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: GetApplicationRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GetApplicationRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationRequestType $getApplicationRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setGetApplicationRequest(\Webservice\Service\Dto\SmevSoap\StructType\GetApplicationRequestType $getApplicationRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($getApplicationRequestChoiceErrorMessage = self::validateGetApplicationRequestForChoiceConstraintsFromSetGetApplicationRequest($getApplicationRequest))) {
            throw new \InvalidArgumentException($getApplicationRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($getApplicationRequest) || (is_array($getApplicationRequest) && empty($getApplicationRequest))) {
            unset($this->GetApplicationRequest);
        } else {
            $this->GetApplicationRequest = $getApplicationRequest;
        }
        return $this;
    }
    /**
     * Get GetApplicationAdmissionRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationAdmissionRequestType|null
     */
    public function getGetApplicationAdmissionRequest()
    {
        return isset($this->GetApplicationAdmissionRequest) ? $this->GetApplicationAdmissionRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGetApplicationAdmissionRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetApplicationAdmissionRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGetApplicationAdmissionRequestForChoiceConstraintsFromSetGetApplicationAdmissionRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationRequest',
            'ApplicationOrderInfoRequest',
            'ApplicationAdmissionRequest',
            'GetApplicationQueueRequest',
            'GetApplicationQueueReasonRequest',
            'GetApplicationRequest',
            'ApplicationRejectionRequest',
            'cancelRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GetApplicationAdmissionRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: GetApplicationAdmissionRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GetApplicationAdmissionRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\GetApplicationAdmissionRequestType $getApplicationAdmissionRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setGetApplicationAdmissionRequest(\Webservice\Service\Dto\SmevSoap\StructType\GetApplicationAdmissionRequestType $getApplicationAdmissionRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($getApplicationAdmissionRequestChoiceErrorMessage = self::validateGetApplicationAdmissionRequestForChoiceConstraintsFromSetGetApplicationAdmissionRequest($getApplicationAdmissionRequest))) {
            throw new \InvalidArgumentException($getApplicationAdmissionRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($getApplicationAdmissionRequest) || (is_array($getApplicationAdmissionRequest) && empty($getApplicationAdmissionRequest))) {
            unset($this->GetApplicationAdmissionRequest);
        } else {
            $this->GetApplicationAdmissionRequest = $getApplicationAdmissionRequest;
        }
        return $this;
    }
    /**
     * Get ApplicationRejectionRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationRejectionRequestType|null
     */
    public function getApplicationRejectionRequest()
    {
        return isset($this->ApplicationRejectionRequest) ? $this->ApplicationRejectionRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setApplicationRejectionRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicationRejectionRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateApplicationRejectionRequestForChoiceConstraintsFromSetApplicationRejectionRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationRequest',
            'ApplicationOrderInfoRequest',
            'ApplicationAdmissionRequest',
            'GetApplicationQueueRequest',
            'GetApplicationQueueReasonRequest',
            'GetApplicationRequest',
            'GetApplicationAdmissionRequest',
            'cancelRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ApplicationRejectionRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ApplicationRejectionRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ApplicationRejectionRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ApplicationRejectionRequestType $applicationRejectionRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setApplicationRejectionRequest(\Webservice\Service\Dto\SmevSoap\StructType\ApplicationRejectionRequestType $applicationRejectionRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($applicationRejectionRequestChoiceErrorMessage = self::validateApplicationRejectionRequestForChoiceConstraintsFromSetApplicationRejectionRequest($applicationRejectionRequest))) {
            throw new \InvalidArgumentException($applicationRejectionRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($applicationRejectionRequest) || (is_array($applicationRejectionRequest) && empty($applicationRejectionRequest))) {
            unset($this->ApplicationRejectionRequest);
        } else {
            $this->ApplicationRejectionRequest = $applicationRejectionRequest;
        }
        return $this;
    }
    /**
     * Get cancelRequest value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\CancelRequestType|null
     */
    public function getCancelRequest()
    {
        return isset($this->cancelRequest) ? $this->cancelRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCancelRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancelRequestForChoiceConstraintsFromSetCancelRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApplicationRequest',
            'ApplicationOrderInfoRequest',
            'ApplicationAdmissionRequest',
            'GetApplicationQueueRequest',
            'GetApplicationQueueReasonRequest',
            'GetApplicationRequest',
            'GetApplicationAdmissionRequest',
            'ApplicationRejectionRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property cancelRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: cancelRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set cancelRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\CancelRequestType $cancelRequest
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormDataType
     */
    public function setCancelRequest(\Webservice\Service\Dto\SmevSoap\StructType\CancelRequestType $cancelRequest = null)
    {
        // validation for constraint: choice(ApplicationRequest, ApplicationOrderInfoRequest, ApplicationAdmissionRequest, GetApplicationQueueRequest, GetApplicationQueueReasonRequest, GetApplicationRequest, GetApplicationAdmissionRequest, ApplicationRejectionRequest, cancelRequest)
        if ('' !== ($cancelRequestChoiceErrorMessage = self::validateCancelRequestForChoiceConstraintsFromSetCancelRequest($cancelRequest))) {
            throw new \InvalidArgumentException($cancelRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($cancelRequest) || (is_array($cancelRequest) && empty($cancelRequest))) {
            unset($this->cancelRequest);
        } else {
            $this->cancelRequest = $cancelRequest;
        }
        return $this;
    }
}
