<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChildInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Сведения о ребёнке
 * @subpackage Structs
 */
class ChildInfoType extends AbstractStructBase
{
    /**
     * The ChildSurname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $ChildSurname;
    /**
     * The ChildName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $ChildName;
    /**
     * The ChildMiddleName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $ChildMiddleName;
    /**
     * The ChildBirthDate
     * @var string
     */
    public $ChildBirthDate;
    /**
     * The ChildBirthDocRF
     * Meta information extracted from the WSDL
     * - choice: ChildBirthDocRF | ChildBirthDocForeign
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocRFType
     */
    public $ChildBirthDocRF;
    /**
     * The ChildBirthDocForeign
     * Meta information extracted from the WSDL
     * - choice: ChildBirthDocRF | ChildBirthDocForeign
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType
     */
    public $ChildBirthDocForeign;
    /**
     * Constructor method for ChildInfoType
     * @uses ChildInfoType::setChildSurname()
     * @uses ChildInfoType::setChildName()
     * @uses ChildInfoType::setChildMiddleName()
     * @uses ChildInfoType::setChildBirthDate()
     * @uses ChildInfoType::setChildBirthDocRF()
     * @uses ChildInfoType::setChildBirthDocForeign()
     * @param string $childSurname
     * @param string $childName
     * @param string $childMiddleName
     * @param string $childBirthDate
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocRFType $childBirthDocRF
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType $childBirthDocForeign
     */
    public function __construct($childSurname = null, $childName = null, $childMiddleName = null, $childBirthDate = null, \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocRFType $childBirthDocRF = null, \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType $childBirthDocForeign = null)
    {
        $this
            ->setChildSurname($childSurname)
            ->setChildName($childName)
            ->setChildMiddleName($childMiddleName)
            ->setChildBirthDate($childBirthDate)
            ->setChildBirthDocRF($childBirthDocRF)
            ->setChildBirthDocForeign($childBirthDocForeign);
    }
    /**
     * Get ChildSurname value
     * @return string|null
     */
    public function getChildSurname()
    {
        return $this->ChildSurname;
    }
    /**
     * Set ChildSurname value
     * @param string $childSurname
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public function setChildSurname($childSurname = null)
    {
        // validation for constraint: string
        if (!is_null($childSurname) && !is_string($childSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childSurname, true), gettype($childSurname)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childSurname) && mb_strlen($childSurname) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childSurname)), __LINE__);
        }
        $this->ChildSurname = $childSurname;
        return $this;
    }
    /**
     * Get ChildName value
     * @return string|null
     */
    public function getChildName()
    {
        return $this->ChildName;
    }
    /**
     * Set ChildName value
     * @param string $childName
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public function setChildName($childName = null)
    {
        // validation for constraint: string
        if (!is_null($childName) && !is_string($childName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childName, true), gettype($childName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childName) && mb_strlen($childName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childName)), __LINE__);
        }
        $this->ChildName = $childName;
        return $this;
    }
    /**
     * Get ChildMiddleName value
     * @return string|null
     */
    public function getChildMiddleName()
    {
        return $this->ChildMiddleName;
    }
    /**
     * Set ChildMiddleName value
     * @param string $childMiddleName
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public function setChildMiddleName($childMiddleName = null)
    {
        // validation for constraint: string
        if (!is_null($childMiddleName) && !is_string($childMiddleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childMiddleName, true), gettype($childMiddleName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childMiddleName) && mb_strlen($childMiddleName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childMiddleName)), __LINE__);
        }
        $this->ChildMiddleName = $childMiddleName;
        return $this;
    }
    /**
     * Get ChildBirthDate value
     * @return string|null
     */
    public function getChildBirthDate()
    {
        return $this->ChildBirthDate;
    }
    /**
     * Set ChildBirthDate value
     * @param string $childBirthDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public function setChildBirthDate($childBirthDate = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDate) && !is_string($childBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDate, true), gettype($childBirthDate)), __LINE__);
        }
        $this->ChildBirthDate = $childBirthDate;
        return $this;
    }
    /**
     * Get ChildBirthDocRF value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocRFType|null
     */
    public function getChildBirthDocRF()
    {
        return isset($this->ChildBirthDocRF) ? $this->ChildBirthDocRF : null;
    }
    /**
     * This method is responsible for validating the value passed to the setChildBirthDocRF method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChildBirthDocRF method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateChildBirthDocRFForChoiceConstraintsFromSetChildBirthDocRF($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ChildBirthDocForeign',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ChildBirthDocRF can\'t be set as the property %s is already set. Only one property must be set among these properties: ChildBirthDocRF, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ChildBirthDocRF value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocRFType $childBirthDocRF
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public function setChildBirthDocRF(\Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocRFType $childBirthDocRF = null)
    {
        // validation for constraint: choice(ChildBirthDocRF, ChildBirthDocForeign)
        if ('' !== ($childBirthDocRFChoiceErrorMessage = self::validateChildBirthDocRFForChoiceConstraintsFromSetChildBirthDocRF($childBirthDocRF))) {
            throw new \InvalidArgumentException($childBirthDocRFChoiceErrorMessage, __LINE__);
        }
        if (is_null($childBirthDocRF) || (is_array($childBirthDocRF) && empty($childBirthDocRF))) {
            unset($this->ChildBirthDocRF);
        } else {
            $this->ChildBirthDocRF = $childBirthDocRF;
        }
        return $this;
    }
    /**
     * Get ChildBirthDocForeign value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType|null
     */
    public function getChildBirthDocForeign()
    {
        return isset($this->ChildBirthDocForeign) ? $this->ChildBirthDocForeign : null;
    }
    /**
     * This method is responsible for validating the value passed to the setChildBirthDocForeign method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChildBirthDocForeign method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateChildBirthDocForeignForChoiceConstraintsFromSetChildBirthDocForeign($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ChildBirthDocRF',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ChildBirthDocForeign can\'t be set as the property %s is already set. Only one property must be set among these properties: ChildBirthDocForeign, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ChildBirthDocForeign value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType $childBirthDocForeign
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public function setChildBirthDocForeign(\Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType $childBirthDocForeign = null)
    {
        // validation for constraint: choice(ChildBirthDocRF, ChildBirthDocForeign)
        if ('' !== ($childBirthDocForeignChoiceErrorMessage = self::validateChildBirthDocForeignForChoiceConstraintsFromSetChildBirthDocForeign($childBirthDocForeign))) {
            throw new \InvalidArgumentException($childBirthDocForeignChoiceErrorMessage, __LINE__);
        }
        if (is_null($childBirthDocForeign) || (is_array($childBirthDocForeign) && empty($childBirthDocForeign))) {
            unset($this->ChildBirthDocForeign);
        } else {
            $this->ChildBirthDocForeign = $childBirthDocForeign;
        }
        return $this;
    }
}
