<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BenefitInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Сведения о документе, подтверждающем право на получение мер специальной поддержки
 * @subpackage Structs
 */
class BenefitInfoType extends AbstractStructBase
{
    /**
     * The BenefitCategory
     * @var \Webservice\Service\Dto\SmevSoap\StructType\DataElementType
     */
    public $BenefitCategory;
    /**
     * The BenefitDocInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\DocInfoType
     */
    public $BenefitDocInfo;
    /**
     * The BenefitFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType[]
     */
    public $BenefitFile;
    /**
     * Constructor method for BenefitInfoType
     * @uses BenefitInfoType::setBenefitCategory()
     * @uses BenefitInfoType::setBenefitDocInfo()
     * @uses BenefitInfoType::setBenefitFile()
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $benefitCategory
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DocInfoType $benefitDocInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType[] $benefitFile
     */
    public function __construct(\Webservice\Service\Dto\SmevSoap\StructType\DataElementType $benefitCategory = null, \Webservice\Service\Dto\SmevSoap\StructType\DocInfoType $benefitDocInfo = null, array $benefitFile = array())
    {
        $this
            ->setBenefitCategory($benefitCategory)
            ->setBenefitDocInfo($benefitDocInfo)
            ->setBenefitFile($benefitFile);
    }
    /**
     * Get BenefitCategory value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DataElementType|null
     */
    public function getBenefitCategory()
    {
        return $this->BenefitCategory;
    }
    /**
     * Set BenefitCategory value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $benefitCategory
     * @return \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType
     */
    public function setBenefitCategory(\Webservice\Service\Dto\SmevSoap\StructType\DataElementType $benefitCategory = null)
    {
        $this->BenefitCategory = $benefitCategory;
        return $this;
    }
    /**
     * Get BenefitDocInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DocInfoType|null
     */
    public function getBenefitDocInfo()
    {
        return $this->BenefitDocInfo;
    }
    /**
     * Set BenefitDocInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DocInfoType $benefitDocInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType
     */
    public function setBenefitDocInfo(\Webservice\Service\Dto\SmevSoap\StructType\DocInfoType $benefitDocInfo = null)
    {
        $this->BenefitDocInfo = $benefitDocInfo;
        return $this;
    }
    /**
     * Get BenefitFile value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType[]|null
     */
    public function getBenefitFile()
    {
        return $this->BenefitFile;
    }
    /**
     * This method is responsible for validating the values passed to the setBenefitFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBenefitFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBenefitFileForArrayConstraintsFromSetBenefitFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $benefitInfoTypeBenefitFileItem) {
            // validation for constraint: itemType
            if (!$benefitInfoTypeBenefitFileItem instanceof \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType) {
                $invalidValues[] = is_object($benefitInfoTypeBenefitFileItem) ? get_class($benefitInfoTypeBenefitFileItem) : sprintf('%s(%s)', gettype($benefitInfoTypeBenefitFileItem), var_export($benefitInfoTypeBenefitFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BenefitFile property can only contain items of type \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BenefitFile value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType[] $benefitFile
     * @return \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType
     */
    public function setBenefitFile(array $benefitFile = array())
    {
        // validation for constraint: array
        if ('' !== ($benefitFileArrayErrorMessage = self::validateBenefitFileForArrayConstraintsFromSetBenefitFile($benefitFile))) {
            throw new \InvalidArgumentException($benefitFileArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($benefitFile) && count($benefitFile) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($benefitFile)), __LINE__);
        }
        $this->BenefitFile = $benefitFile;
        return $this;
    }
    /**
     * Add item to BenefitFile value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType $item
     * @return \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType
     */
    public function addToBenefitFile(\Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType) {
            throw new \InvalidArgumentException(sprintf('The BenefitFile property can only contain items of type \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->BenefitFile) && count($this->BenefitFile) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->BenefitFile)), __LINE__);
        }
        $this->BenefitFile[] = $item;
        return $this;
    }
}
