<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationOrderInfoRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Подача заявления на получение информации об этапах и результатах оказания услуги зачисления в дошкольную организацию
 * @subpackage Structs
 */
class ApplicationOrderInfoRequestType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The ServicesType
     * Meta information extracted from the WSDL
     * - base: xsd:normalizedString
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ServicesType;
    /**
     * The PersonInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType
     */
    public $PersonInfo;
    /**
     * The PersonIdentityDocInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType
     */
    public $PersonIdentityDocInfo;
    /**
     * The ChildInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public $ChildInfo;
    /**
     * Constructor method for ApplicationOrderInfoRequestType
     * @uses ApplicationOrderInfoRequestType::setOrderId()
     * @uses ApplicationOrderInfoRequestType::setServicesType()
     * @uses ApplicationOrderInfoRequestType::setPersonInfo()
     * @uses ApplicationOrderInfoRequestType::setPersonIdentityDocInfo()
     * @uses ApplicationOrderInfoRequestType::setChildInfo()
     * @param int $orderId
     * @param string $servicesType
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo
     */
    public function __construct($orderId = null, $servicesType = null, \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo = null, \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo = null, \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo = null)
    {
        $this
            ->setOrderId($orderId)
            ->setServicesType($servicesType)
            ->setPersonInfo($personInfo)
            ->setPersonIdentityDocInfo($personIdentityDocInfo)
            ->setChildInfo($childInfo);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get ServicesType value
     * @return string|null
     */
    public function getServicesType()
    {
        return $this->ServicesType;
    }
    /**
     * Set ServicesType value
     * @param string $servicesType
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType
     */
    public function setServicesType($servicesType = null)
    {
        // validation for constraint: string
        if (!is_null($servicesType) && !is_string($servicesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicesType, true), gettype($servicesType)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($servicesType) && mb_strlen($servicesType) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($servicesType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($servicesType) && mb_strlen($servicesType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($servicesType)), __LINE__);
        }
        $this->ServicesType = $servicesType;
        return $this;
    }
    /**
     * Get PersonInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType|null
     */
    public function getPersonInfo()
    {
        return $this->PersonInfo;
    }
    /**
     * Set PersonInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType
     */
    public function setPersonInfo(\Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo = null)
    {
        $this->PersonInfo = $personInfo;
        return $this;
    }
    /**
     * Get PersonIdentityDocInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType|null
     */
    public function getPersonIdentityDocInfo()
    {
        return $this->PersonIdentityDocInfo;
    }
    /**
     * Set PersonIdentityDocInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType
     */
    public function setPersonIdentityDocInfo(\Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo = null)
    {
        $this->PersonIdentityDocInfo = $personIdentityDocInfo;
        return $this;
    }
    /**
     * Get ChildInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType|null
     */
    public function getChildInfo()
    {
        return $this->ChildInfo;
    }
    /**
     * Set ChildInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationOrderInfoRequestType
     */
    public function setChildInfo(\Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo = null)
    {
        $this->ChildInfo = $childInfo;
        return $this;
    }
}
