<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationAdmissionRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Подача заявления о приёме в дошкольную организацию
 * @subpackage Structs
 */
class ApplicationAdmissionRequestType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The ServicesType
     * Meta information extracted from the WSDL
     * - base: xsd:normalizedString
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ServicesType;
    /**
     * The PersonInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType
     */
    public $PersonInfo;
    /**
     * The PersonIdentityDocInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType
     */
    public $PersonIdentityDocInfo;
    /**
     * The Person2Info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType
     */
    public $Person2Info;
    /**
     * The ChildInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public $ChildInfo;
    /**
     * The Address
     * @var \Webservice\Service\Dto\SmevSoap\StructType\AddressType
     */
    public $Address;
    /**
     * The EntryParams
     * @var \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType
     */
    public $EntryParams;
    /**
     * The AdaptationProgram
     * @var \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType
     */
    public $AdaptationProgram;
    /**
     * The MedicalReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public $MedicalReport;
    /**
     * The EduOrganizationCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $EduOrganizationCode;
    /**
     * The DocListReview
     * @var bool
     */
    public $DocListReview;
    /**
     * The LicenseCharter
     * @var bool
     */
    public $LicenseCharter;
    /**
     * Constructor method for ApplicationAdmissionRequestType
     * @uses ApplicationAdmissionRequestType::setOrderId()
     * @uses ApplicationAdmissionRequestType::setServicesType()
     * @uses ApplicationAdmissionRequestType::setPersonInfo()
     * @uses ApplicationAdmissionRequestType::setPersonIdentityDocInfo()
     * @uses ApplicationAdmissionRequestType::setPerson2Info()
     * @uses ApplicationAdmissionRequestType::setChildInfo()
     * @uses ApplicationAdmissionRequestType::setAddress()
     * @uses ApplicationAdmissionRequestType::setEntryParams()
     * @uses ApplicationAdmissionRequestType::setAdaptationProgram()
     * @uses ApplicationAdmissionRequestType::setMedicalReport()
     * @uses ApplicationAdmissionRequestType::setEduOrganizationCode()
     * @uses ApplicationAdmissionRequestType::setDocListReview()
     * @uses ApplicationAdmissionRequestType::setLicenseCharter()
     * @param int $orderId
     * @param string $servicesType
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType $person2Info
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AddressType $address
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType $entryParams
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType $adaptationProgram
     * @param \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType $medicalReport
     * @param string $eduOrganizationCode
     * @param bool $docListReview
     * @param bool $licenseCharter
     */
    public function __construct($orderId = null, $servicesType = null, \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo = null, \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo = null, \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType $person2Info = null, \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo = null, \Webservice\Service\Dto\SmevSoap\StructType\AddressType $address = null, \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType $entryParams = null, \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType $adaptationProgram = null, \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType $medicalReport = null, $eduOrganizationCode = null, $docListReview = null, $licenseCharter = null)
    {
        $this
            ->setOrderId($orderId)
            ->setServicesType($servicesType)
            ->setPersonInfo($personInfo)
            ->setPersonIdentityDocInfo($personIdentityDocInfo)
            ->setPerson2Info($person2Info)
            ->setChildInfo($childInfo)
            ->setAddress($address)
            ->setEntryParams($entryParams)
            ->setAdaptationProgram($adaptationProgram)
            ->setMedicalReport($medicalReport)
            ->setEduOrganizationCode($eduOrganizationCode)
            ->setDocListReview($docListReview)
            ->setLicenseCharter($licenseCharter);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get ServicesType value
     * @return string|null
     */
    public function getServicesType()
    {
        return $this->ServicesType;
    }
    /**
     * Set ServicesType value
     * @param string $servicesType
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setServicesType($servicesType = null)
    {
        // validation for constraint: string
        if (!is_null($servicesType) && !is_string($servicesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicesType, true), gettype($servicesType)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($servicesType) && mb_strlen($servicesType) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($servicesType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($servicesType) && mb_strlen($servicesType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($servicesType)), __LINE__);
        }
        $this->ServicesType = $servicesType;
        return $this;
    }
    /**
     * Get PersonInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType|null
     */
    public function getPersonInfo()
    {
        return $this->PersonInfo;
    }
    /**
     * Set PersonInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setPersonInfo(\Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo = null)
    {
        $this->PersonInfo = $personInfo;
        return $this;
    }
    /**
     * Get PersonIdentityDocInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType|null
     */
    public function getPersonIdentityDocInfo()
    {
        return $this->PersonIdentityDocInfo;
    }
    /**
     * Set PersonIdentityDocInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setPersonIdentityDocInfo(\Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo = null)
    {
        $this->PersonIdentityDocInfo = $personIdentityDocInfo;
        return $this;
    }
    /**
     * Get Person2Info value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType|null
     */
    public function getPerson2Info()
    {
        return $this->Person2Info;
    }
    /**
     * Set Person2Info value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType $person2Info
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setPerson2Info(\Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType $person2Info = null)
    {
        $this->Person2Info = $person2Info;
        return $this;
    }
    /**
     * Get ChildInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType|null
     */
    public function getChildInfo()
    {
        return $this->ChildInfo;
    }
    /**
     * Set ChildInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setChildInfo(\Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo = null)
    {
        $this->ChildInfo = $childInfo;
        return $this;
    }
    /**
     * Get Address value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AddressType $address
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setAddress(\Webservice\Service\Dto\SmevSoap\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EntryParams value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType|null
     */
    public function getEntryParams()
    {
        return $this->EntryParams;
    }
    /**
     * Set EntryParams value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType $entryParams
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setEntryParams(\Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType $entryParams = null)
    {
        $this->EntryParams = $entryParams;
        return $this;
    }
    /**
     * Get AdaptationProgram value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType|null
     */
    public function getAdaptationProgram()
    {
        return $this->AdaptationProgram;
    }
    /**
     * Set AdaptationProgram value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType $adaptationProgram
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setAdaptationProgram(\Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType $adaptationProgram = null)
    {
        $this->AdaptationProgram = $adaptationProgram;
        return $this;
    }
    /**
     * Get MedicalReport value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType|null
     */
    public function getMedicalReport()
    {
        return $this->MedicalReport;
    }
    /**
     * Set MedicalReport value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType $medicalReport
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setMedicalReport(\Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType $medicalReport = null)
    {
        $this->MedicalReport = $medicalReport;
        return $this;
    }
    /**
     * Get EduOrganizationCode value
     * @return string|null
     */
    public function getEduOrganizationCode()
    {
        return $this->EduOrganizationCode;
    }
    /**
     * Set EduOrganizationCode value
     * @param string $eduOrganizationCode
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setEduOrganizationCode($eduOrganizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($eduOrganizationCode) && !is_string($eduOrganizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eduOrganizationCode, true), gettype($eduOrganizationCode)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($eduOrganizationCode) && mb_strlen($eduOrganizationCode) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($eduOrganizationCode)), __LINE__);
        }
        $this->EduOrganizationCode = $eduOrganizationCode;
        return $this;
    }
    /**
     * Get DocListReview value
     * @return bool|null
     */
    public function getDocListReview()
    {
        return $this->DocListReview;
    }
    /**
     * Set DocListReview value
     * @param bool $docListReview
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setDocListReview($docListReview = null)
    {
        // validation for constraint: boolean
        if (!is_null($docListReview) && !is_bool($docListReview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($docListReview, true), gettype($docListReview)), __LINE__);
        }
        $this->DocListReview = $docListReview;
        return $this;
    }
    /**
     * Get LicenseCharter value
     * @return bool|null
     */
    public function getLicenseCharter()
    {
        return $this->LicenseCharter;
    }
    /**
     * Set LicenseCharter value
     * @param bool $licenseCharter
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationAdmissionRequestType
     */
    public function setLicenseCharter($licenseCharter = null)
    {
        // validation for constraint: boolean
        if (!is_null($licenseCharter) && !is_bool($licenseCharter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($licenseCharter, true), gettype($licenseCharter)), __LINE__);
        }
        $this->LicenseCharter = $licenseCharter;
        return $this;
    }
}
