<?php

namespace Webservice\Service\Dto\SmevSoap\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CancelResultType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Результат передачи запроса на отмену заявления
 * @subpackage Enumerations
 */
class CancelResultType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'CANCELLED'
     * @return string 'CANCELLED'
     */
    const VALUE_CANCELLED = 'CANCELLED';
    /**
     * Constant for value 'IN_PROGRESS'
     * @return string 'IN_PROGRESS'
     */
    const VALUE_IN_PROGRESS = 'IN_PROGRESS';
    /**
     * Constant for value 'REJECTED'
     * @return string 'REJECTED'
     */
    const VALUE_REJECTED = 'REJECTED';
    /**
     * Return allowed values
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_REJECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CANCELLED,
            self::VALUE_IN_PROGRESS,
            self::VALUE_REJECTED,
        );
    }
}
