<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedicalReportType StructType
 * Meta information extracted from the WSDL
 * - documentation: Реквизиты документа, подтверждающего группу коменсирующей направленности
 * @subpackage Structs
 */
class MedicalReportType extends AbstractStructBase
{
    /**
     * The DocName
     * @var \Webservice\Service\Dto\SmevSoap\StructType\DataElementType
     */
    public $DocName;
    /**
     * The DocSeries
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $DocSeries;
    /**
     * The DocNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * @var string
     */
    public $DocNumber;
    /**
     * The DocIssueDate
     * @var string
     */
    public $DocIssueDate;
    /**
     * The DocIssued
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $DocIssued;
    /**
     * The DocExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocExpirationDate;
    /**
     * The DocFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType[]
     */
    public $DocFile;
    /**
     * Constructor method for MedicalReportType
     * @uses MedicalReportType::setDocName()
     * @uses MedicalReportType::setDocSeries()
     * @uses MedicalReportType::setDocNumber()
     * @uses MedicalReportType::setDocIssueDate()
     * @uses MedicalReportType::setDocIssued()
     * @uses MedicalReportType::setDocExpirationDate()
     * @uses MedicalReportType::setDocFile()
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $docName
     * @param string $docSeries
     * @param string $docNumber
     * @param string $docIssueDate
     * @param string $docIssued
     * @param string $docExpirationDate
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType[] $docFile
     */
    public function __construct(\Webservice\Service\Dto\SmevSoap\StructType\DataElementType $docName = null, $docSeries = null, $docNumber = null, $docIssueDate = null, $docIssued = null, $docExpirationDate = null, array $docFile = array())
    {
        $this
            ->setDocName($docName)
            ->setDocSeries($docSeries)
            ->setDocNumber($docNumber)
            ->setDocIssueDate($docIssueDate)
            ->setDocIssued($docIssued)
            ->setDocExpirationDate($docExpirationDate)
            ->setDocFile($docFile);
    }
    /**
     * Get DocName value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DataElementType|null
     */
    public function getDocName()
    {
        return $this->DocName;
    }
    /**
     * Set DocName value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $docName
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public function setDocName(\Webservice\Service\Dto\SmevSoap\StructType\DataElementType $docName = null)
    {
        $this->DocName = $docName;
        return $this;
    }
    /**
     * Get DocSeries value
     * @return string|null
     */
    public function getDocSeries()
    {
        return $this->DocSeries;
    }
    /**
     * Set DocSeries value
     * @param string $docSeries
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public function setDocSeries($docSeries = null)
    {
        // validation for constraint: string
        if (!is_null($docSeries) && !is_string($docSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docSeries, true), gettype($docSeries)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($docSeries) && mb_strlen($docSeries) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($docSeries)), __LINE__);
        }
        $this->DocSeries = $docSeries;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($docNumber) && mb_strlen($docNumber) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocIssueDate value
     * @return string|null
     */
    public function getDocIssueDate()
    {
        return $this->DocIssueDate;
    }
    /**
     * Set DocIssueDate value
     * @param string $docIssueDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public function setDocIssueDate($docIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueDate) && !is_string($docIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueDate, true), gettype($docIssueDate)), __LINE__);
        }
        $this->DocIssueDate = $docIssueDate;
        return $this;
    }
    /**
     * Get DocIssued value
     * @return string|null
     */
    public function getDocIssued()
    {
        return $this->DocIssued;
    }
    /**
     * Set DocIssued value
     * @param string $docIssued
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public function setDocIssued($docIssued = null)
    {
        // validation for constraint: string
        if (!is_null($docIssued) && !is_string($docIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssued, true), gettype($docIssued)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($docIssued) && mb_strlen($docIssued) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($docIssued)), __LINE__);
        }
        $this->DocIssued = $docIssued;
        return $this;
    }
    /**
     * Get DocExpirationDate value
     * @return string|null
     */
    public function getDocExpirationDate()
    {
        return $this->DocExpirationDate;
    }
    /**
     * Set DocExpirationDate value
     * @param string $docExpirationDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public function setDocExpirationDate($docExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($docExpirationDate) && !is_string($docExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docExpirationDate, true), gettype($docExpirationDate)), __LINE__);
        }
        $this->DocExpirationDate = $docExpirationDate;
        return $this;
    }
    /**
     * Get DocFile value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType[]|null
     */
    public function getDocFile()
    {
        return $this->DocFile;
    }
    /**
     * This method is responsible for validating the values passed to the setDocFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocFileForArrayConstraintsFromSetDocFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $medicalReportTypeDocFileItem) {
            // validation for constraint: itemType
            if (!$medicalReportTypeDocFileItem instanceof \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType) {
                $invalidValues[] = is_object($medicalReportTypeDocFileItem) ? get_class($medicalReportTypeDocFileItem) : sprintf('%s(%s)', gettype($medicalReportTypeDocFileItem), var_export($medicalReportTypeDocFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocFile property can only contain items of type \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocFile value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType[] $docFile
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public function setDocFile(array $docFile = array())
    {
        // validation for constraint: array
        if ('' !== ($docFileArrayErrorMessage = self::validateDocFileForArrayConstraintsFromSetDocFile($docFile))) {
            throw new \InvalidArgumentException($docFileArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($docFile) && count($docFile) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($docFile)), __LINE__);
        }
        $this->DocFile = $docFile;
        return $this;
    }
    /**
     * Add item to DocFile value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType $item
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public function addToDocFile(\Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType) {
            throw new \InvalidArgumentException(sprintf('The DocFile property can only contain items of type \Webservice\Service\Dto\SmevSoap\StructType\AppliedDocumentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->DocFile) && count($this->DocFile) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->DocFile)), __LINE__);
        }
        $this->DocFile[] = $item;
        return $this;
    }
}
